/*
 * Decompiled with CFR 0.152.
 */
package imageServer.config;

import freemarker.template.TemplateModelException;
import imageServer.config.ImageConfigVo;
import imageServer.utils.ImageScaleImpl;
import javax.annotation.PostConstruct;
import javax.servlet.Servlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;
import org.springframework.web.servlet.view.freemarker.FreeMarkerConfigurer;

@Configuration
public class WebConfig {
    private static final Logger logger = LoggerFactory.getLogger(WebConfig.class);
    private String ueditorMapping = "/image/api/ueditor";
    @Autowired
    private ImageConfigVo imageConfigVo;
    @Autowired
    FreeMarkerConfigurer freeMarkerConfigurer;

    @Bean
    ServletRegistrationBean ueditorServlet() {
        ServletRegistrationBean servletRegistrationBean = new ServletRegistrationBean((Servlet)new /* Unavailable Anonymous Inner Class!! */, new String[]{this.ueditorMapping});
        return servletRegistrationBean;
    }

    @Bean
    public WebMvcConfigurerAdapter mvcConfig(ImageConfigVo imageConfig) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @ConfigurationProperties(prefix="image")
    @Bean
    ImageConfigVo imageConfig() {
        return new ImageConfigVo();
    }

    @Bean(initMethod="init")
    ImageScaleImpl imageScale() {
        return new ImageScaleImpl();
    }

    @PostConstruct
    void inited() throws TemplateModelException {
        if (logger.isInfoEnabled()) {
            logger.info("\u4e0a\u4f20\u670d\u52a1\u5668\u914d\u7f6e\uff1a{}", (Object)this.imageConfig());
        }
        this.freeMarkerConfigurer.getConfiguration().setSharedVariable("_imageConfig", (Object)this.imageConfig());
    }

    static /* synthetic */ ImageConfigVo access$000(WebConfig x0) {
        return x0.imageConfigVo;
    }
}

