/*
 * Decompiled with CFR 0.152.
 */
package imageServer.fck;

import imageServer.fck.PropertiesLoader;
import imageServer.fck.Utils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * Exception performing whole class analysis ignored.
 */
public class ResourceType {
    private String name;
    private String path;
    private Set<String> allowedEextensions;
    private Set<String> deniedExtensions;
    private static Map<String, ResourceType> types = new HashMap(4);
    public static final ResourceType FILE = new ResourceType("File", PropertiesLoader.getFileResourceTypePath(), Utils.getSet((String)PropertiesLoader.getFileResourceTypeAllowedExtensions()), Utils.getSet((String)PropertiesLoader.getFileResourceTypeDeniedExtensions()));
    public static final ResourceType FLASH = new ResourceType("Flash", PropertiesLoader.getFlashResourceTypePath(), Utils.getSet((String)PropertiesLoader.getFlashResourceTypeAllowedExtensions()), Utils.getSet((String)PropertiesLoader.getFlashResourceTypeDeniedExtensions()));
    public static final ResourceType IMAGE = new ResourceType("Image", PropertiesLoader.getImageResourceTypePath(), Utils.getSet((String)PropertiesLoader.getImageResourceTypeAllowedExtensions()), Utils.getSet((String)PropertiesLoader.getImageResourceTypeDeniedExtensions()));
    public static final ResourceType MEDIA = new ResourceType("Media", PropertiesLoader.getMediaResourceTypePath(), Utils.getSet((String)PropertiesLoader.getMediaResourceTypeAllowedExtensions()), Utils.getSet((String)PropertiesLoader.getMediaResourceTypeDeniedExtensions()));

    private ResourceType(String name, String path, Set<String> allowedEextensions, Set<String> deniedExtensions) {
        this.name = name;
        this.path = path;
        if (allowedEextensions.isEmpty() && deniedExtensions.isEmpty()) {
            throw new IllegalArgumentException("Both sets are empty, one has always to be filled");
        }
        if (!allowedEextensions.isEmpty() && !deniedExtensions.isEmpty()) {
            throw new IllegalArgumentException("Both sets contain extensions, only one can be filled at the same time");
        }
        this.allowedEextensions = allowedEextensions;
        this.deniedExtensions = deniedExtensions;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public Set<String> getAllowedEextensions() {
        return Collections.unmodifiableSet(this.allowedEextensions);
    }

    public Set<String> getDeniedExtensions() {
        return Collections.unmodifiableSet(this.deniedExtensions);
    }

    public static ResourceType valueOf(String name) {
        if (Utils.isEmpty((String)name)) {
            throw new NullPointerException("Name is null or empty");
        }
        ResourceType rt = (ResourceType)types.get(name);
        if (rt == null) {
            throw new IllegalArgumentException("No resource type const " + name);
        }
        return rt;
    }

    public static boolean isValidType(String name) {
        return types.containsKey(name);
    }

    public static ResourceType getResourceType(String name) {
        try {
            return ResourceType.valueOf((String)name);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static ResourceType getDefaultResourceType(String name) {
        ResourceType rt = ResourceType.getResourceType((String)name);
        return rt == null ? FILE : rt;
    }

    public boolean isAllowedExtension(String extension) {
        if (Utils.isEmpty((String)extension)) {
            return false;
        }
        String ext = extension.toLowerCase();
        if (this.allowedEextensions.isEmpty()) {
            return !this.deniedExtensions.contains(ext);
        }
        if (this.deniedExtensions.isEmpty()) {
            return this.allowedEextensions.contains(ext);
        }
        return false;
    }

    @Deprecated
    public boolean isNotAllowedExtension(String extension) {
        return !this.isAllowedExtension(extension);
    }

    public boolean isDeniedExtension(String extension) {
        return !this.isAllowedExtension(extension);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ResourceType rt = (ResourceType)obj;
        return this.name.equals(rt.getName());
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    static {
        types.put(FILE.getName(), FILE);
        types.put(FLASH.getName(), FLASH);
        types.put(IMAGE.getName(), IMAGE);
        types.put(MEDIA.getName(), MEDIA);
    }
}

