/*
 * Decompiled with CFR 0.152.
 */
package imageServer.web;

import imageServer.config.ImageConfigVo;
import imageServer.utils.ImageUtils;
import imageServer.vo.ImageUploadResponseVo;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import net.coobird.thumbnailator.Thumbnails;
import net.coobird.thumbnailator.geometry.Position;
import net.coobird.thumbnailator.geometry.Positions;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.DigestUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

public abstract class AbstractUploadAct {
    private static final Logger logger = LoggerFactory.getLogger(AbstractUploadAct.class);
    @Autowired
    protected ImageConfigVo imageConfigVo;

    public ImageConfigVo getImageConfigVo() {
        return this.imageConfigVo;
    }

    public void setImageConfigVo(ImageConfigVo imageConfigVo) {
        this.imageConfigVo = imageConfigVo;
    }

    protected List<ImageUploadResponseVo> uploadFiles(HttpServletRequest request, MultipartHttpServletRequest mrequest) throws IOException {
        ArrayList<ImageUploadResponseVo> responseVos = new ArrayList<ImageUploadResponseVo>();
        String saveFilePathStr = this.getImageConfigVo().getFullSaveFilePath() + new DateTime().toString("yyyy-MM-dd") + "/";
        File savefilePathDir = new File(saveFilePathStr);
        if (!savefilePathDir.exists()) {
            savefilePathDir.mkdirs();
        }
        for (MultipartFile file : mrequest.getFileMap().values()) {
            if (file == null || file.isEmpty()) continue;
            ImageUploadResponseVo responseVo = new ImageUploadResponseVo();
            String fileName = null;
            String fileNameExt = ImageUtils.getFileNameExt((String)file.getOriginalFilename());
            if (mrequest.getParameter(file.getName() + "_name") != null) {
                fileName = request.getParameter(file.getName() + "_name").toString();
                if (fileName.indexOf(".") < 0) {
                    fileName = fileName + "." + fileNameExt;
                }
            } else {
                fileName = request.getParameter(file.getName() + "_sourceName") != null || !ImageUtils.isImage((String)fileNameExt) ? file.getOriginalFilename() : (file.getSize() < 1024L ? DigestUtils.md5DigestAsHex((byte[])file.getBytes()) + "." + fileNameExt : DigestUtils.md5DigestAsHex((byte[])file.getOriginalFilename().getBytes()) + "." + fileNameExt);
            }
            fileName = this.getSimpleFileName(fileName);
            File newFile = new File(saveFilePathStr + fileName);
            if (newFile.exists()) {
                newFile = new File(saveFilePathStr + System.currentTimeMillis() + fileName);
            }
            file.transferTo(newFile);
            String newFilePath = newFile.getAbsolutePath().replaceAll("//", "/").replaceAll("\\\\", "/");
            responseVo.setFilePath(newFilePath.substring(newFilePath.indexOf(this.getImageConfigVo().getPath())));
            responseVo.setAbsoluteFilePath(this.getImageConfigVo().getDomain() + responseVo.getFilePath());
            responseVo.setName(fileName);
            responseVo.setSourceName(new String(file.getOriginalFilename().getBytes("ISO-8859-1"), "UTF-8"));
            if ("true".equals(request.getParameter(file.getName() + "_mark")) && ImageUtils.isImage((String)fileNameExt)) {
                String fileStr = newFile.getAbsolutePath() + "_mark." + fileNameExt;
                File waterMarkFile = new File(fileStr);
                Thumbnails.of((File[])new File[]{newFile}).watermark((Position)Positions.BOTTOM_RIGHT, this.getImageConfigVo().getBufferedImage(), this.getImageConfigVo().getWqterQuality()).scale(1.0).toFile(waterMarkFile);
                fileStr = fileStr.replaceAll("//", "/").replaceAll("\\\\", "/");
                responseVo.setMarkFilePath(fileStr.substring(fileStr.indexOf(this.getImageConfigVo().getPath())));
                responseVo.setMarkAbsoluteFilePath(this.getImageConfigVo().getDomain() + responseVo.getMarkFilePath());
            }
            if (ImageUtils.isImage((String)fileNameExt)) {
                BufferedImage bufferedImage = ImageIO.read(newFile);
                responseVo.setWidth((float)bufferedImage.getWidth());
                responseVo.setHeight((float)bufferedImage.getHeight());
            }
            responseVos.add(responseVo);
        }
        return responseVos;
    }

    protected File getUploadedFile(String path) {
        File imageFlie = null;
        String saveFilePathStr = this.getImageConfigVo().getFullSaveFilePath();
        saveFilePathStr = saveFilePathStr.endsWith("/") ? saveFilePathStr.substring(0, saveFilePathStr.length() - 1) : saveFilePathStr;
        saveFilePathStr.replaceAll("//", "/");
        String p = this.getImageConfigVo().getPath();
        String string = p = p.endsWith("/") ? p.substring(0, p.length() - 1) : p;
        if (!StringUtils.isEmpty((Object)path)) {
            path = path.startsWith(p) ? path.replace(p, "") : path;
            String absFilePath = saveFilePathStr + path;
            imageFlie = new File(absFilePath);
        }
        return imageFlie;
    }

    protected String transCharacter(HttpServletRequest request, String str) throws Exception {
        if (request.getHeader("USER-AGENT").toLowerCase().indexOf("msie") > 0) {
            return URLEncoder.encode(str, "UTF-8");
        }
        if (request.getHeader("USER-AGENT").toLowerCase().indexOf("firefox") > 0) {
            return new String(str.getBytes("UTF-8"), "ISO8859-1");
        }
        return new String(str.getBytes("UTF-8"), "ISO8859-1");
    }

    private String getSimpleFileName(String fileName) {
        if (fileName.indexOf("/") >= 0) {
            fileName = fileName.substring(fileName.lastIndexOf("/") + 1);
        } else if (fileName.indexOf("\\") >= 0) {
            fileName = fileName.substring(fileName.lastIndexOf("\\") + 1);
        }
        return fileName;
    }
}

