/*
 * Decompiled with CFR 0.152.
 */
package imageServer.web;

import com.alibaba.fastjson.JSON;
import imageServer.web.AbstractUploadAct;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"/image/api"})
public class FileUploadController
extends AbstractUploadAct {
    private static final Logger logger = LoggerFactory.getLogger(FileUploadController.class);

    @RequestMapping(method={RequestMethod.POST})
    @ResponseBody
    public Object upload(HttpServletRequest request, HttpServletResponse response) throws IOException {
        MultipartHttpServletRequest mrequest = (MultipartHttpServletRequest)request;
        response.setHeader("Access-Control-Allow-Origin", "*");
        List responseVos = this.uploadFiles(request, mrequest);
        return responseVos;
    }

    @RequestMapping(value={"textjson"}, method={RequestMethod.POST}, produces={"text/html; charset=UTF-8"})
    @ResponseBody
    public String uploadText(HttpServletRequest request, HttpServletResponse response) throws IOException {
        MultipartHttpServletRequest mrequest = (MultipartHttpServletRequest)request;
        response.setHeader("Access-Control-Allow-Origin", "*");
        response.setHeader("Content-Type", "text/html;charset=utf-8");
        List responseVos = this.uploadFiles(request, mrequest);
        return JSON.toJSONString((Object)responseVos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"download"}, method={RequestMethod.GET}, produces={"text/html; charset=UTF-8"})
    public void download(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String path = request.getParameter("path");
        String fileName = request.getParameter("fileName");
        fileName = URLDecoder.decode(fileName, "utf-8");
        response.setContentType("application/x-download");
        response.addHeader("content-type ", "application/x-msdownload");
        response.setContentType("application/octet-stream");
        response.setHeader("content-disposition", "attachment; filename=" + this.transCharacter(request, fileName));
        File file = this.getUploadedFile(path);
        if (file != null) {
            BufferedInputStream bufferedInputStream = null;
            Object inputStream = null;
            BufferedOutputStream bufferedOutputStream = null;
            try {
                bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                response.addHeader("Content-Length", bufferedInputStream.available() + "");
                bufferedOutputStream = new BufferedOutputStream((OutputStream)response.getOutputStream());
                byte[] bytes = new byte[1024];
                while (bufferedInputStream.read(bytes) > -1) {
                    bufferedOutputStream.write(bytes);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    bufferedInputStream.close();
                    bufferedOutputStream.flush();
                    bufferedOutputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

