/*
 * Decompiled with CFR 0.152.
 */
package imageServer.web.ckeditorImgPaste;

import imageServer.config.ImageConfigVo;
import imageServer.web.ckeditorImgPaste.ImageUploadUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/image/protocol/richText"})
public class ProtocolRichTextController {
    Logger logger = LoggerFactory.getLogger(ProtocolRichTextController.class);
    @Autowired
    protected ImageConfigVo imageConfigVo;
    private static final String FOLDER_NAME = "ckeditorpaste";

    public ImageConfigVo getImageConfigVo() {
        return this.imageConfigVo;
    }

    public void setImageConfigVo(ImageConfigVo imageConfigVo) {
        this.imageConfigVo = imageConfigVo;
    }

    @RequestMapping(value={"/imageUpload"})
    public void imageUpload(HttpServletRequest request, HttpServletResponse response) {
        String saveFilePathStr = this.getImageConfigVo().getFullSaveFilePath();
        if (!saveFilePathStr.endsWith(File.separator)) {
            saveFilePathStr = saveFilePathStr + File.separator;
        }
        String DirectoryName = saveFilePathStr + FOLDER_NAME + File.separator;
        try {
            ImageUploadUtil.ckeditor((HttpServletRequest)request, (HttpServletResponse)response, (String)DirectoryName);
        }
        catch (IllegalStateException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @RequestMapping(value={"/imagePaste"})
    public void imagePaste(HttpServletRequest request, HttpServletResponse response) {
        String saveFilePathStr = this.getImageConfigVo().getFullSaveFilePath();
        if (!saveFilePathStr.endsWith(File.separator)) {
            saveFilePathStr = saveFilePathStr + File.separator;
        }
        String DirectoryName = saveFilePathStr + FOLDER_NAME + File.separator;
        try {
            ImageUploadUtil.ckeditorImgPaste((HttpServletRequest)request, (HttpServletResponse)response, (String)DirectoryName);
        }
        catch (IllegalStateException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @RequestMapping(value={"/uploadView/{name}"})
    public void uploadBrowser(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="name") String name) {
        String[] tmp;
        String saveFilePathStr = this.getImageConfigVo().getFullSaveFilePath();
        if (!saveFilePathStr.endsWith(File.separator)) {
            saveFilePathStr = saveFilePathStr + File.separator;
        }
        String DirectoryName = saveFilePathStr + FOLDER_NAME + File.separator;
        String realPath = DirectoryName + name;
        String suffix = "png";
        if (!name.contains(".") && name.contains("+") && (tmp = name.split("\\+")) != null && tmp.length == 2) {
            realPath = DirectoryName + name + "." + tmp[1];
            suffix = tmp[1];
        }
        try {
            File file = new File(realPath);
            if (!file.exists() || !file.canRead()) {
                // empty if block
            }
            FileInputStream inputStream = new FileInputStream(file);
            byte[] data = new byte[(int)file.length()];
            int length = inputStream.read(data);
            inputStream.close();
            response.setContentType("image/" + suffix);
            ServletOutputStream stream = response.getOutputStream();
            stream.write(data);
            stream.flush();
            stream.close();
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

