/*
 * Decompiled with CFR 0.152.
 */
package imageServer.web.facade;

import imageServer.utils.ImageScale;
import imageServer.vo.ImageUploadResponseVo;
import imageServer.web.AbstractUploadAct;
import imageServer.web.FileUploadController;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"/image/api"})
public class JSPGouController
extends AbstractUploadAct {
    private static final Logger logger = LoggerFactory.getLogger(FileUploadController.class);
    private static final String ERROR = "error";
    private static final String UPLOAD_IFRAME_UPLOAD = "/upload/iframeUpload";
    private static final String UPLOAD_IFRAME_SWITCH_UPLOAD = "/upload/iframe_switch_upload";
    @Autowired
    ImageScale imageScale;

    @RequestMapping(value={"/doImageCut"})
    public String imageCut(String imgSrcPath, Integer imgTop, Integer imgLeft, Integer imgWidth, Integer imgHeight, Integer reMinWidth, Integer reMinHeight, Float imgScale, Integer uploadNum, HttpServletRequest request, ModelMap model) {
        String ctx = request.getContextPath();
        imgSrcPath = imgSrcPath.substring(ctx.length());
        String real = imgSrcPath.replace(this.imageConfigVo.getDomain(), "");
        File srcFile = new File((this.imageConfigVo.getSavePath() + "/" + real).replaceAll("//", "/"));
        model.addAttribute("uploadNum", (Object)uploadNum);
        try {
            if (imgWidth != null) {
                if (imgWidth > 0) {
                    this.imageScale.resizeFix(srcFile, srcFile, reMinWidth.intValue(), reMinHeight.intValue(), this.getLen(imgTop.intValue(), imgScale.floatValue()), this.getLen(imgLeft.intValue(), imgScale.floatValue()), this.getLen(imgWidth.intValue(), imgScale.floatValue()), this.getLen(imgHeight.intValue(), imgScale.floatValue()));
                } else {
                    this.imageScale.resizeFix(srcFile, srcFile, reMinWidth.intValue(), reMinHeight.intValue());
                }
            } else {
                model.addAttribute(ERROR, (Object)"\u56fe\u7247\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        catch (Exception e) {
            logger.error("cut image error", (Throwable)e);
            model.addAttribute(ERROR, (Object)e.getMessage());
        }
        return "/upload/image_cuted";
    }

    private int getLen(int len, float imgScale) {
        return Math.round((float)len / imgScale);
    }

    @RequestMapping(value={"/iframeUpload"}, method={RequestMethod.POST})
    public String iframeUpload(Integer uploadNum, Integer zoomWidth, Integer zoomHeight, HttpServletRequest request, ModelMap model) throws IOException {
        try {
            MultipartHttpServletRequest mrequest = (MultipartHttpServletRequest)request;
            List responseVos = this.uploadFiles(request, mrequest);
            if (responseVos == null || responseVos.size() == 0) {
                model.put((Object)ERROR, (Object)"\u672a\u4e0a\u4f20\u6587\u4ef6");
                return UPLOAD_IFRAME_UPLOAD;
            }
            ImageUploadResponseVo imageUploadResponseVo = (ImageUploadResponseVo)responseVos.get(0);
            model.addAttribute("zoomWidth", (Object)zoomWidth);
            model.addAttribute("zoomHeight", (Object)zoomHeight);
            model.addAttribute("uploadPath", (Object)imageUploadResponseVo.getAbsoluteFilePath());
            model.addAttribute("uploadNum", (Object)uploadNum);
        }
        catch (Exception e) {
            model.addAttribute(ERROR, (Object)e.getMessage());
            logger.error("\u4e0a\u4f20\u6587\u4ef6\u5904\u7406\u51fa\u9519", (Throwable)e);
        }
        return UPLOAD_IFRAME_UPLOAD;
    }

    @RequestMapping(value={"/switchIframeUpload"}, method={RequestMethod.POST})
    public String iframeUpload(String fileName, Integer uploadNum, @RequestParam(value="uploadFileSwitch", required=false) MultipartFile file, HttpServletRequest request, ModelMap model) throws IOException {
        try {
            MultipartHttpServletRequest mrequest = (MultipartHttpServletRequest)request;
            List responseVos = this.uploadFiles(request, mrequest);
            if (responseVos == null || responseVos.size() == 0) {
                model.put((Object)ERROR, (Object)"\u672a\u4e0a\u4f20\u6587\u4ef6");
                return UPLOAD_IFRAME_SWITCH_UPLOAD;
            }
            ImageUploadResponseVo imageUploadResponseVo = (ImageUploadResponseVo)responseVos.get(0);
            model.addAttribute("uploadPath", (Object)imageUploadResponseVo.getAbsoluteFilePath());
            model.addAttribute("uploadNum", (Object)uploadNum);
        }
        catch (Exception e) {
            model.addAttribute(ERROR, (Object)e.getMessage());
            logger.error("\u4e0a\u4f20\u6587\u4ef6\u5904\u7406\u51fa\u9519", (Throwable)e);
        }
        return UPLOAD_IFRAME_SWITCH_UPLOAD;
    }

    @RequestMapping(value={"/ampIframeUpload"})
    public String ampIfameUpload(String fileName, Integer uploadNum, @RequestParam(value="uploadFileAmp", required=false) MultipartFile file, HttpServletRequest request, ModelMap model) {
        try {
            MultipartHttpServletRequest mrequest = (MultipartHttpServletRequest)request;
            List responseVos = this.uploadFiles(request, mrequest);
            if (responseVos == null || responseVos.size() == 0) {
                model.put((Object)ERROR, (Object)"\u672a\u4e0a\u4f20\u6587\u4ef6");
                return UPLOAD_IFRAME_SWITCH_UPLOAD;
            }
            ImageUploadResponseVo imageUploadResponseVo = (ImageUploadResponseVo)responseVos.get(0);
            model.addAttribute("uploadPath", (Object)imageUploadResponseVo.getAbsoluteFilePath());
            model.addAttribute("uploadNum", (Object)uploadNum);
        }
        catch (Exception e) {
            model.addAttribute(ERROR, (Object)e.getMessage());
            logger.error("\u4e0a\u4f20\u6587\u4ef6\u5904\u7406\u51fa\u9519", (Throwable)e);
        }
        return "upload/iframe_amp_upload";
    }

    @RequestMapping(value={"/bigIframeUpload"})
    public String bigIfameUpload(String fileName, Integer uploadNum, @RequestParam(value="uploadFileBig", required=false) MultipartFile file, HttpServletRequest request, ModelMap model) {
        try {
            MultipartHttpServletRequest mrequest = (MultipartHttpServletRequest)request;
            List responseVos = this.uploadFiles(request, mrequest);
            if (responseVos == null || responseVos.size() == 0) {
                model.put((Object)ERROR, (Object)"\u672a\u4e0a\u4f20\u6587\u4ef6");
                return UPLOAD_IFRAME_SWITCH_UPLOAD;
            }
            ImageUploadResponseVo imageUploadResponseVo = (ImageUploadResponseVo)responseVos.get(0);
            model.addAttribute("uploadPath", (Object)imageUploadResponseVo.getAbsoluteFilePath());
            model.addAttribute("uploadNum", (Object)uploadNum);
        }
        catch (Exception e) {
            model.addAttribute(ERROR, (Object)e.getMessage());
            logger.error("\u4e0a\u4f20\u6587\u4ef6\u5904\u7406\u51fa\u9519", (Throwable)e);
        }
        return "upload/iframe_big_upload";
    }

    @RequestMapping(value={"/imageCut"})
    public String imageAreaSelect(String imgSrcPath, Integer zoomWidth, Integer zoomHeight, Integer uploadNum, HttpServletRequest request, ModelMap model) {
        model.addAttribute("imgSrcPath", (Object)imgSrcPath);
        model.addAttribute("zoomWidth", (Object)zoomWidth);
        model.addAttribute("zoomHeight", (Object)zoomHeight);
        model.addAttribute("uploadNum", (Object)uploadNum);
        return "/upload/image_area_select";
    }
}

