/*
 * Decompiled with CFR 0.152.
 */
package imageServer.web.facade;

import imageServer.utils.DigestUtil;
import java.io.File;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;
import ueditor.ActionEnter;

@Controller
@RequestMapping(value={"/image/ueditor"})
public class UeditorController {
    private static final Logger log = LoggerFactory.getLogger(UeditorController.class);
    private static final String allowType = ".jpg,.jpeg,.png,.gif,.bmp";

    @RequestMapping(value={"/config"})
    public void ueditor(HttpServletRequest request, HttpServletResponse response) {
        response.setHeader("Content-Type", "text/html");
        response.setContentType("application/json");
        String rootPath = request.getServletContext().getRealPath("/");
        try {
            request.setCharacterEncoding("utf-8");
            String exec = new ActionEnter(request, rootPath).exec();
            PrintWriter writer = response.getWriter();
            writer.write(exec);
            writer.flush();
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @RequestMapping(value={"/create2"}, method={RequestMethod.POST})
    @ResponseBody
    public Object create(HttpServletRequest request) {
        HashMap<String, String> result = new HashMap<String, String>();
        String url = "";
        CommonsMultipartResolver multipartResolver = new CommonsMultipartResolver(request.getSession().getServletContext());
        if (multipartResolver.isMultipart(request)) {
            MultipartHttpServletRequest multiRequest = (MultipartHttpServletRequest)request;
            Iterator iter = multiRequest.getFileNames();
            while (iter.hasNext()) {
                MultipartFile file = multiRequest.getFile((String)iter.next());
                if (file.isEmpty()) continue;
                try {
                    String path = request.getSession().getServletContext().getRealPath("/img/upload");
                    String fileName = file.getOriginalFilename();
                    Assert.isTrue((fileName.indexOf(".") >= 0 ? 1 : 0) != 0, (String)"\u672a\u627e\u5230\u56fe\u7247\u540e\u7f00\u540d");
                    String fileType = fileName.substring(fileName.lastIndexOf("."));
                    Assert.hasText((String)fileType, (String)"\u672a\u627e\u5230\u56fe\u7247\u540e\u7f00\u540d");
                    Assert.isTrue((boolean)allowType.contains(fileType), (String)"\u4e0d\u5141\u8bb8\u4e0a\u4f20\u7684\u56fe\u7247\u7c7b\u578b");
                    fileName = DigestUtil.md5((String)(fileName + new Date().getTime() + Math.random())) + fileType;
                    File f = new File(path + "/" + fileName);
                    FileUtils.copyInputStreamToFile((InputStream)file.getInputStream(), (File)f);
                    url = "/img/upload/" + fileName;
                    result.put("url", url);
                }
                catch (Exception e) {
                    result.put("error", e.getMessage());
                }
            }
        }
        return result;
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    @ResponseBody
    public Object create(@RequestParam(value="image") MultipartFile file, HttpServletRequest request) {
        HashMap<String, String> result = new HashMap<String, String>();
        String url = "";
        if (file != null && !file.isEmpty()) {
            try {
                String path = request.getSession().getServletContext().getRealPath("/img/upload");
                String fileName = file.getOriginalFilename();
                Assert.isTrue((fileName.indexOf(".") >= 0 ? 1 : 0) != 0, (String)"\u672a\u627e\u5230\u56fe\u7247\u540e\u7f00\u540d");
                String fileType = fileName.substring(fileName.lastIndexOf("."));
                Assert.hasText((String)fileType, (String)"\u672a\u627e\u5230\u56fe\u7247\u540e\u7f00\u540d");
                Assert.isTrue((boolean)allowType.contains(fileType), (String)"\u4e0d\u5141\u8bb8\u4e0a\u4f20\u7684\u56fe\u7247\u7c7b\u578b");
                fileName = DigestUtil.md5((String)(fileName + new Date().getTime() + Math.random())) + fileType;
                File f = new File(path + "/" + fileName);
                FileUtils.copyInputStreamToFile((InputStream)file.getInputStream(), (File)f);
                url = "/img/upload/" + fileName;
                result.put("url", url);
            }
            catch (Exception e) {
                result.put("error", e.getMessage());
            }
        }
        return result;
    }
}

