package imageServer.config;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ResourceUtils;

import javax.annotation.PostConstruct;
import javax.imageio.ImageIO;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.Serializable;

/**
 * Created by xiaoqian on 2016/8/31.
 */
public class ImageConfigVo implements Serializable{

    private static final Logger logger = LoggerFactory.getLogger(ImageConfigVo.class);

    public static final String API_PATH="/image/api";
    public static final String CONSOLE_PATH="/image/console";
    public static final String UEDITOR_PATH="/image/ueditor";

    public ImageConfigVo() {
    }

    /**
     * 图片服务器域名
     */
    private String domain;

    /**
     * 图片上传路径
     */
    private String path;

    /**
     * 图片保存路径
     */
    private String savePath;

    /**
     * 图片压缩系数
     */
    private float wqterQuality = 0.8f;

    private String fullSaveFilePath;

    private String waterMarkImg;

    private BufferedImage bufferedImage;

    @PostConstruct
    public void inited(){
        if(waterMarkImg!=null && !"".equals(waterMarkImg.trim())){
            try {
                bufferedImage = ImageIO.read(ResourceUtils.getFile(waterMarkImg));
            } catch (IOException e) {
                logger.error("取水印图片时出错"+e.getMessage(),e);
                //e.printStackTrace();
            }
        }
    }

    public BufferedImage getBufferedImage() {
        return bufferedImage;
    }

    public String getWaterMarkImg() {
        return waterMarkImg;
    }

    public void setWaterMarkImg(String waterMarkImg) {
        this.waterMarkImg = waterMarkImg;
    }

    public String getFullSaveFilePath(){
        if(fullSaveFilePath!=null){
            return fullSaveFilePath;
        }
        if(path!=null && !"".equals(path)){
            fullSaveFilePath = (savePath+"/"+path).replaceAll("///","/").replaceAll("//","/");
        }else{
            fullSaveFilePath = savePath;
        }
        if(!savePath.endsWith("/")){
            fullSaveFilePath = fullSaveFilePath +"/";
        }

        return fullSaveFilePath;
    }

    public float getWqterQuality() {
        return wqterQuality;
    }

    public void setWqterQuality(float wqterQuality) {
        this.wqterQuality = wqterQuality;
    }

    public String getDomain() {
        return domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getPath() {
        return path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getSavePath() {
        return savePath;
    }

    public void setSavePath(String savePath) {
        this.savePath = savePath;
    }

    @Override
    public String toString() {
        return "ImageConfigVo{" +
                "domain='" + domain + '\'' +
                ", path='" + path + '\'' +
                ", savePath='" + savePath + '\'' +
                ", wqterQuality=" + wqterQuality +
                ", waterMarkImg='" + waterMarkImg + '\'' +
                '}';
    }
}
