/*
 * Decompiled with CFR 0.152.
 */
package imageServer.config;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.Serializable;
import javax.annotation.PostConstruct;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ResourceUtils;

public class ImageConfigVo
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(ImageConfigVo.class);
    public static final String API_PATH = "/image/api";
    public static final String CONSOLE_PATH = "/image/console";
    public static final String UEDITOR_PATH = "/image/ueditor";
    private String domain;
    private String path;
    private String savePath;
    private float wqterQuality = 0.8f;
    private String fullSaveFilePath;
    private String waterMarkImg;
    private BufferedImage bufferedImage;

    @PostConstruct
    public void inited() {
        if (this.waterMarkImg != null && !"".equals(this.waterMarkImg.trim())) {
            try {
                this.bufferedImage = ImageIO.read(ResourceUtils.getFile((String)this.waterMarkImg));
            }
            catch (IOException e) {
                logger.error("\u53d6\u6c34\u5370\u56fe\u7247\u65f6\u51fa\u9519" + e.getMessage(), (Throwable)e);
            }
        }
    }

    public BufferedImage getBufferedImage() {
        return this.bufferedImage;
    }

    public String getWaterMarkImg() {
        return this.waterMarkImg;
    }

    public void setWaterMarkImg(String waterMarkImg) {
        this.waterMarkImg = waterMarkImg;
    }

    public String getFullSaveFilePath() {
        if (this.fullSaveFilePath != null) {
            return this.fullSaveFilePath;
        }
        this.fullSaveFilePath = this.path != null && !"".equals(this.path) ? (this.savePath + "/" + this.path).replaceAll("///", "/").replaceAll("//", "/") : this.savePath;
        if (!this.savePath.endsWith("/")) {
            this.fullSaveFilePath = this.fullSaveFilePath + "/";
        }
        return this.fullSaveFilePath;
    }

    public float getWqterQuality() {
        return this.wqterQuality;
    }

    public void setWqterQuality(float wqterQuality) {
        this.wqterQuality = wqterQuality;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getSavePath() {
        return this.savePath;
    }

    public void setSavePath(String savePath) {
        this.savePath = savePath;
    }

    public String toString() {
        return "ImageConfigVo{domain='" + this.domain + '\'' + ", path='" + this.path + '\'' + ", savePath='" + this.savePath + '\'' + ", wqterQuality=" + this.wqterQuality + ", waterMarkImg='" + this.waterMarkImg + '\'' + '}';
    }
}

