/*
 * Decompiled with CFR 0.152.
 */
package imageServer.utils;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.apache.commons.io.FileUtils;

public class AverageImageScale {
    public static void resizeFix(File srcFile, File destFile, int boxWidth, int boxHeight) throws IOException {
        try {
            int zoomHeight;
            int zoomWidth;
            BufferedImage srcImgBuff = ImageIO.read(srcFile);
            int width = srcImgBuff.getWidth();
            int height = srcImgBuff.getHeight();
            if (width <= boxWidth && height <= boxHeight) {
                FileUtils.copyFile((File)srcFile, (File)destFile);
                return;
            }
            if ((float)width / (float)height > (float)boxWidth / (float)boxHeight) {
                zoomWidth = boxWidth;
                zoomHeight = Math.round((float)boxWidth * (float)height / (float)width);
            } else {
                zoomWidth = Math.round((float)boxHeight * (float)width / (float)height);
                zoomHeight = boxHeight;
            }
            BufferedImage imgBuff = AverageImageScale.scaleImage(srcImgBuff, width, height, zoomWidth, zoomHeight);
            AverageImageScale.writeFile(imgBuff, destFile);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    public static void resizeFix(File file, File file1, int i, int j, int k, int l, int i1, int j1) throws IOException {
        try {
            int j2;
            int i2;
            BufferedImage bufferedimage = ImageIO.read(file);
            bufferedimage = bufferedimage.getSubimage(k, l, i1, j1);
            int k1 = bufferedimage.getWidth();
            int l1 = bufferedimage.getHeight();
            if (k1 <= i && l1 <= j) {
                AverageImageScale.writeFile(bufferedimage, file1);
                return;
            }
            if ((float)k1 / (float)l1 > (float)i / (float)j) {
                i2 = i;
                j2 = Math.round((float)i * (float)l1 / (float)k1);
            } else {
                i2 = Math.round((float)j * (float)k1 / (float)l1);
                j2 = j;
            }
            BufferedImage bufferedimage1 = AverageImageScale.scaleImage(bufferedimage, k1, l1, i2, j2);
            AverageImageScale.writeFile(bufferedimage1, file1);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    public static void writeFile(BufferedImage imgBuf, File destFile) throws IOException {
        File parent = destFile.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        ImageIO.write((RenderedImage)imgBuf, "jpeg", destFile);
    }

    private static BufferedImage scaleImage(BufferedImage srcImgBuff, int width, int height, int zoomWidth, int zoomHeight) {
        int[] colorArray = srcImgBuff.getRGB(0, 0, width, height, null, 0, width);
        BufferedImage outBuff = new BufferedImage(zoomWidth, zoomHeight, 1);
        float wScale = (float)width / (float)zoomWidth;
        int wScaleInt = (int)((double)wScale + 0.5);
        float hScale = (float)height / (float)zoomHeight;
        int hScaleInt = (int)((double)hScale + 0.5);
        int area = wScaleInt * hScaleInt;
        for (int y = 0; y < zoomHeight; ++y) {
            int y0 = (int)((float)y * hScale);
            int y1 = y0 + hScaleInt;
            for (int x = 0; x < zoomWidth; ++x) {
                int x0 = (int)((float)x * wScale);
                int x1 = x0 + wScaleInt;
                long blue = 0L;
                long green = 0L;
                long red = 0L;
                for (int i = x0; i < x1; ++i) {
                    for (int j = y0; j < y1; ++j) {
                        int color = colorArray[width * j + i];
                        red += (long)AverageImageScale.getRedValue(color);
                        green += (long)AverageImageScale.getGreenValue(color);
                        blue += (long)AverageImageScale.getBlueValue(color);
                    }
                }
                outBuff.setRGB(x, y, AverageImageScale.comRGB((int)(red / (long)area), (int)(green / (long)area), (int)(blue / (long)area)));
            }
        }
        return outBuff;
    }

    private static int getRedValue(int rgbValue) {
        return (rgbValue & 0xFF0000) >> 16;
    }

    private static int getGreenValue(int rgbValue) {
        return (rgbValue & 0xFF00) >> 8;
    }

    private static int getBlueValue(int rgbValue) {
        return rgbValue & 0xFF;
    }

    private static int comRGB(int redValue, int greenValue, int blueValue) {
        return (redValue << 16) + (greenValue << 8) + blueValue;
    }

    public static void main(String[] args) throws Exception {
        long time = System.currentTimeMillis();
        AverageImageScale.resizeFix(new File("test/com/jeecms/common/util/1.bmp"), new File("test/com/jeecms/common/util/1-n-2.bmp"), 310, 310, 50, 50, 320, 320);
        time = System.currentTimeMillis() - time;
        System.out.println("resize2 img in " + time + "ms");
    }
}

