/*
 * Decompiled with CFR 0.152.
 */
package imageServer.utils;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class DigestUtil {
    private static final String PASSWORD_TOKEN = "cdXDk49k23-";

    public static String encodePassword(String password) {
        return DigestUtil.md5(PASSWORD_TOKEN + password + PASSWORD_TOKEN);
    }

    public static final String md5(String s) {
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        try {
            byte[] btInput = s.getBytes("utf-8");
            MessageDigest mdInst = MessageDigest.getInstance("MD5");
            mdInst.update(btInput);
            byte[] md = mdInst.digest();
            int j = md.length;
            char[] str = new char[j * 2];
            int k = 0;
            for (int i = 0; i < j; ++i) {
                byte byte0 = md[i];
                str[k++] = hexDigits[byte0 >>> 4 & 0xF];
                str[k++] = hexDigits[byte0 & 0xF];
            }
            return new String(str);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static final byte[] md5bytes(String s) {
        try {
            byte[] btInput = s.getBytes("utf-8");
            MessageDigest mdInst = MessageDigest.getInstance("MD5");
            mdInst.update(btInput);
            return mdInst.digest();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static final String md5(byte[] bytes) {
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        try {
            MessageDigest mdInst = MessageDigest.getInstance("MD5");
            mdInst.update(bytes);
            byte[] md = mdInst.digest();
            int j = md.length;
            char[] str = new char[j * 2];
            int k = 0;
            for (int i = 0; i < j; ++i) {
                byte byte0 = md[i];
                str[k++] = hexDigits[byte0 >>> 4 & 0xF];
                str[k++] = hexDigits[byte0 & 0xF];
            }
            return new String(str);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static final String base64enc(byte[] data) {
        return new BASE64Encoder().encode(data);
    }

    public static final byte[] base64dec(String string) throws IOException {
        return new BASE64Decoder().decodeBuffer(string);
    }

    public static final byte[] encrypt(byte[] data, byte[] key) throws Exception {
        SecureRandom sr = new SecureRandom(key);
        DESKeySpec dks = new DESKeySpec(key);
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DES");
        SecretKey securekey = keyFactory.generateSecret(dks);
        Cipher cipher = Cipher.getInstance("DES");
        cipher.init(1, (Key)securekey, sr);
        return cipher.doFinal(data);
    }

    public static final byte[] decrypt(byte[] data, byte[] key) throws Exception {
        SecureRandom sr = new SecureRandom(key);
        DESKeySpec dks = new DESKeySpec(key);
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DES");
        SecretKey securekey = keyFactory.generateSecret(dks);
        Cipher cipher = Cipher.getInstance("DES");
        cipher.init(2, (Key)securekey, sr);
        return cipher.doFinal(data);
    }

    public static final byte[] dechexString(String hexString) {
        int length = hexString.length() / 2;
        byte[] bytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            bytes[i] = (byte)(Byte.valueOf(hexString.substring(i * 2, i * 2 + 1), 16) << 4 | Byte.valueOf(hexString.substring(i * 2 + 1, i * 2 + 2), 16));
        }
        return bytes;
    }

    public static final String enchexString(byte[] bytes) {
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        char[] str = new char[bytes.length * 2];
        int k = 0;
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            str[k++] = hexDigits[b >> 4 & 0xF];
            str[k++] = hexDigits[b & 0xF];
        }
        return new String(str);
    }

    public static final byte[] long2bytes(long v) {
        byte[] bytes = new byte[8];
        DigestUtil.long2bytes(v, bytes, 0);
        return bytes;
    }

    public static final void long2bytes(long v, byte[] bytes, int index) {
        long vv = v;
        for (int i = 7; i >= 0; --i) {
            bytes[index + i] = (byte)(vv & 0xFFL);
            vv >>= 8;
        }
    }

    public static final long bytes2long(byte[] bytes, int index) {
        long v = 0L;
        for (int i = 0; i < 8; ++i) {
            long b = bytes[i + index];
            v = v << 8 | (b &= 0xFFL);
        }
        return v;
    }

    public static final byte[] int2bytes(long v) {
        byte[] bytes = new byte[4];
        DigestUtil.long2bytes(v, bytes, 0);
        return bytes;
    }

    public static final void int2bytes(long v, byte[] bytes, int index) {
        long vv = v;
        for (int i = 3; i >= 0; --i) {
            bytes[index + i] = (byte)(vv & 0xFFL);
            vv >>= 8;
        }
    }

    public static final int bytes2int(byte[] bytes, int index) {
        int v = 0;
        for (int i = 0; i < 4; ++i) {
            int b = bytes[i + index];
            v = v << 8 | (b &= 0xFF);
        }
        return v;
    }

    public static final String md5sign(String key, Map<String, String> values) {
        ArrayList<String> keys = new ArrayList<String>(values.keySet());
        Collections.sort(keys);
        StringBuilder prestr = new StringBuilder();
        for (String k : keys) {
            String v = values.get(k);
            if (v == null || "".equals(v)) continue;
            if (prestr.length() > 0) {
                prestr.append("&").append(k).append("=").append(v);
                continue;
            }
            prestr.append(k).append("=").append(v);
        }
        return DigestUtil.md5(prestr.append(key).toString());
    }

    public static final String sha1(String string) {
        try {
            return DigestUtil.sha1(string.getBytes("utf-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static final String sha1(byte[] bytes) {
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        try {
            MessageDigest mdInst = MessageDigest.getInstance("SHA-1");
            mdInst.update(bytes);
            byte[] md = mdInst.digest();
            int j = md.length;
            char[] str = new char[j * 2];
            int k = 0;
            for (int i = 0; i < j; ++i) {
                byte byte0 = md[i];
                str[k++] = hexDigits[byte0 >>> 4 & 0xF];
                str[k++] = hexDigits[byte0 & 0xF];
            }
            return new String(str);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

