/*
 * Decompiled with CFR 0.152.
 */
package imageServer.utils;

import imageServer.utils.AverageImageScale;
import imageServer.utils.ImageScale;
import imageServer.utils.MagickImageScale;
import java.io.File;
import magick.Magick;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageScaleImpl
implements ImageScale {
    private static final Logger log = LoggerFactory.getLogger(ImageScaleImpl.class);
    private boolean isMagick = false;

    @Override
    public void resizeFix(File srcFile, File destFile, int boxWidth, int boxHeight) throws Exception {
        try {
            if (this.isMagick) {
                MagickImageScale.resizeFix(srcFile, destFile, boxWidth, boxHeight);
            } else {
                AverageImageScale.resizeFix(srcFile, destFile, boxWidth, boxHeight);
            }
        }
        catch (Exception e) {
            log.error("\u88c1\u526a\u56fe\u7247\u51fa\u9519\uff0c\u8bf7\u91cd\u65b0\u88c1\u526a", (Throwable)e);
            System.out.println(e.getMessage());
        }
    }

    @Override
    public void resizeFix(File srcFile, File destFile, int boxWidth, int boxHeight, int cutTop, int cutLeft, int cutWidth, int catHeight) throws Exception {
        try {
            if (this.isMagick) {
                MagickImageScale.resizeFix(srcFile, destFile, boxWidth, boxHeight, cutTop, cutLeft, cutWidth, catHeight);
            } else {
                AverageImageScale.resizeFix(srcFile, destFile, boxWidth, boxHeight, cutTop, cutLeft, cutWidth, catHeight);
            }
        }
        catch (Exception e) {
            log.error("\u88c1\u526a\u56fe\u7247\u51fa\u9519\uff0c\u8bf7\u91cd\u65b0\u88c1\u526a", (Throwable)e);
            System.out.println(e.getMessage());
        }
    }

    public void init() {
        try {
            System.setProperty("jmagick.systemclassloader", "no");
            new Magick();
            log.info("use jmagick");
            this.isMagick = true;
        }
        catch (Throwable throwable) {
            log.warn("load magick fail, use java image scale. message:{}", (Object)throwable.getMessage());
            this.isMagick = false;
        }
    }
}

