/*
 * Decompiled with CFR 0.152.
 */
package imageServer.utils;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import magick.ImageInfo;
import magick.MagickException;
import magick.MagickImage;

public class MagickImageScale {
    public static void resizeFix(File srcFile, File destFile, int boxWidth, int boxHeight) throws IOException, MagickException {
        int zoomHeight;
        int zoomWidth;
        int height;
        ImageInfo info = new ImageInfo(srcFile.getAbsolutePath());
        MagickImage image = new MagickImage(info);
        Dimension dim = image.getDimension();
        int width = (int)dim.getWidth();
        if ((float)width / (float)(height = (int)dim.getHeight()) > (float)boxWidth / (float)boxHeight) {
            zoomWidth = boxWidth;
            zoomHeight = Math.round((float)boxWidth * (float)height / (float)width);
        } else {
            zoomWidth = Math.round((float)boxHeight * (float)width / (float)height);
            zoomHeight = boxHeight;
        }
        MagickImage scaled = image.scaleImage(zoomWidth, zoomHeight);
        scaled.setFileName(destFile.getAbsolutePath());
        scaled.writeImage(info);
        scaled.destroyImages();
    }

    public static void resizeFix(File srcFile, File destFile, int boxWidth, int boxHeight, int cutTop, int cutLeft, int cutWidth, int catHeight) throws IOException, MagickException {
        int zoomHeight;
        int zoomWidth;
        int height;
        Rectangle rect;
        ImageInfo info = new ImageInfo(srcFile.getAbsolutePath());
        MagickImage image = new MagickImage(info);
        MagickImage cropped = image.cropImage(rect = new Rectangle(cutTop, cutLeft, cutWidth, catHeight));
        Dimension dim = cropped.getDimension();
        int width = (int)dim.getWidth();
        if ((float)width / (float)(height = (int)dim.getHeight()) > (float)boxWidth / (float)boxHeight) {
            zoomWidth = boxWidth;
            zoomHeight = Math.round((float)boxWidth * (float)height / (float)width);
        } else {
            zoomWidth = Math.round((float)boxHeight * (float)width / (float)height);
            zoomHeight = boxHeight;
        }
        MagickImage scaled = cropped.scaleImage(zoomWidth, zoomHeight);
        scaled.setFileName(destFile.getAbsolutePath());
        scaled.writeImage(info);
        scaled.destroyImages();
    }
}

