/*
 * Decompiled with CFR 0.152.
 */
package ueditor.upload;

import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import ueditor.PathFormat;
import ueditor.define.BaseState;
import ueditor.define.FileType;
import ueditor.define.State;
import ueditor.upload.StorageManager;

public final class Base64Uploader {
    public static State save(String content, Map<String, Object> conf) {
        long maxSize;
        byte[] data = Base64Uploader.decode(content);
        if (!Base64Uploader.validSize(data, maxSize = ((Long)conf.get("maxSize")).longValue())) {
            return new BaseState(false, 1);
        }
        String suffix = FileType.getSuffix("JPG");
        String savePath = PathFormat.parse((String)conf.get("savePath"), (String)conf.get("filename"));
        savePath = savePath + suffix;
        String physicalPath = (String)conf.get("rootPath") + savePath;
        State storageState = StorageManager.saveBinaryFile(data, physicalPath);
        if (storageState.isSuccess()) {
            storageState.putInfo("url", PathFormat.format(savePath));
            storageState.putInfo("type", suffix);
            storageState.putInfo("original", "");
        }
        return storageState;
    }

    private static byte[] decode(String content) {
        return Base64.decodeBase64((String)content);
    }

    private static boolean validSize(byte[] data, long length) {
        return (long)data.length <= length;
    }
}

