/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.aoplog;

import ins.framework.aoplog.support.AopThreadLocal;
import ins.framework.aoplog.support.Constant;
import ins.framework.aoplog.support.LogAnnotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.safehaus.uuid.UUIDGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Service;

@Service(value="aopLog")
public class AopLog
implements MethodInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"AOPLOG");
    private static Map<String, String> threadData = new HashMap<String, String>();
    private static Map<String, Integer> threadNum = new HashMap<String, Integer>();

    public Object invoke(MethodInvocation invocation) throws Throwable {
        String threadId;
        if (MDC.get((String)"ipflag") == null || "".equals(MDC.get((String)"ipflag"))) {
            MDC.put((String)"ipflag", (String)(Constant.IP + "-" + Constant.DOMAIN));
        }
        if (threadNum.get(threadId = AopLog.getThreadId()) == null) {
            threadNum.put(threadId, 1);
        } else {
            threadNum.put(threadId, threadNum.get(threadId) + 1);
        }
        threadData.put(threadId + "|" + threadNum.get(threadId), AopLog.getUuid());
        String className = "";
        String methodName = "";
        String description = "";
        Method method = invocation.getMethod();
        className = method.getDeclaringClass().getName();
        methodName = method.getName();
        LogAnnotation ann = method.getAnnotation(LogAnnotation.class);
        description = ann == null ? "NONE" : ann.description();
        StringBuilder buf = new StringBuilder();
        buf.append("[").append(AopLog.getServiceId()).append("] [").append(AopLog.getMethodId()).append("] [" + AopLog.getLoginUser()).append("] [").append(className).append(".").append(methodName).append("] [" + description).append("]");
        LOGGER.info(new StringBuilder(buf).append(" [start]").toString());
        Object result = invocation.proceed();
        LOGGER.info(new StringBuilder(buf).append(" [end]").toString());
        threadData.remove(threadId + "|" + threadNum.get(threadId));
        Integer num = threadNum.get(threadId);
        if (num == null) {
            num = 1;
        }
        if (num == 1) {
            threadNum.remove(threadId);
            AopThreadLocal.setAopServiceid(null);
        } else {
            threadNum.put(threadId, num - 1);
        }
        MDC.remove((String)"ipflag");
        return result;
    }

    private static String getMethodId() {
        String threadId = AopLog.getThreadId();
        return threadData.get(threadId + "|" + threadNum.get(threadId));
    }

    private static String getThreadId() {
        return String.valueOf(Thread.currentThread().getId());
    }

    private static String getUuid() {
        return UUIDGenerator.getInstance().generateRandomBasedUUID().toString();
    }

    private static String getServiceId() {
        String serviceID;
        if (AopThreadLocal.getAopServiceid() != null) {
            serviceID = AopThreadLocal.getAopServiceid();
        } else {
            serviceID = AopLog.getUuid();
            AopThreadLocal.setAopServiceid(serviceID);
        }
        return serviceID;
    }

    public static String getLogMethodID() {
        return AopLog.getMethodId();
    }

    public static String getLogServiceID() {
        return AopLog.getServiceId();
    }

    public static String getLoginUser() {
        if (AopThreadLocal.getThreadLocalRequest() != null) {
            return AopThreadLocal.getThreadLocalRequest().getUser();
        }
        return null;
    }

    public static String getIpAndDDomain() {
        return Constant.IPANDDOMAIN;
    }
}

