/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.aoplog.interceptor;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogThreadInterceptor
implements MethodInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogThreadInterceptor.class);
    private static final ThreadLocal<StackData> SD = new ThreadLocal();
    private long minTime = 3000L;
    private String cacheProcessId = null;
    private String dirPath = new File(System.getProperty("java.io.tmpdir"), "LogMethod").getAbsolutePath();

    public void setDirPath(String dirPath) {
        this.dirPath = dirPath;
    }

    public void setMinTime(long minTime) {
        this.minTime = minTime;
    }

    public Object invoke(MethodInvocation mi) throws Throwable {
        StackEntry se = new StackEntry();
        se.thisObject = mi.getThis();
        se.method = mi.getMethod();
        StackEntry.access$202(se, mi.getArguments());
        StackData sd = SD.get();
        if (sd == null) {
            sd = new StackData();
            sd.root = se;
            SD.set(sd);
        } else {
            sd.currentEntry.children.add(se);
            se.parent = sd.currentEntry;
        }
        sd.currentEntry = se;
        se.beginTime = System.currentTimeMillis();
        try {
            Object object = mi.proceed();
            return object;
        }
        catch (Exception e) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn(e.toString(), (Throwable)e);
            }
            throw e;
        }
        finally {
            block13: {
                sd.currentEntry = se.parent;
                se.endTime = System.currentTimeMillis();
                if (sd.root == se) {
                    SD.remove();
                    try {
                        this.log(se);
                    }
                    catch (Exception e) {
                        if (!LOGGER.isWarnEnabled()) break block13;
                        LOGGER.warn(e.toString(), (Throwable)e);
                    }
                }
            }
        }
    }

    public void log(StackEntry root) {
        block4: {
            String pid = this.retrieveProcessId();
            File dir = new File(this.dirPath, pid);
            dir.mkdirs();
            long useTime = root.getEndTime() - root.getBeginTime();
            if (useTime < this.minTime) {
                return;
            }
            if (dir.exists() && dir.isDirectory()) {
                String threadName = "Thread" + Thread.currentThread().getId();
                String fileName = threadName + ".log";
                File file = new File(dir, fileName);
                StringBuilder sb = new StringBuilder();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS ");
                sb.append(LogThreadInterceptor.rightAlign(useTime, 6));
                sb.append("ms ");
                SimpleDateFormat sdf2 = new SimpleDateFormat("HH:mm:ss.SSS");
                sb.append(sdf2.format(root.getBeginTime()));
                sb.append("  ==================================");
                sb.append(sdf.format(new Date()));
                sb.append("Methods execute stack==================================\r\n");
                sb.append(this.stackEntityToString(root));
                sb.append("\r\n");
                try {
                    LogThreadInterceptor.writeFile(file, sb.toString());
                }
                catch (IOException e) {
                    if (!LOGGER.isErrorEnabled()) break block4;
                    LOGGER.error(String.format("wirte file(%s) error:", file.getAbsolutePath()), (Throwable)e);
                }
            }
        }
    }

    private static void writeFile(File file, String s) throws IOException {
        FileOutputStream os = new FileOutputStream(file, true);
        try {
            os.write(s.getBytes());
            os.flush();
        }
        finally {
            os.close();
        }
    }

    private String stackEntityToString(StackEntry root) {
        StringBuilder sb = new StringBuilder();
        this.writeStackEntry(sb, root, root, 0);
        return sb.toString();
    }

    private void writeStackEntry(StringBuilder sb, StackEntry root, StackEntry current, int level) {
        sb.append(LogThreadInterceptor.rightAlign(current.getEndTime() - current.getBeginTime(), 6));
        sb.append("ms ");
        SimpleDateFormat sdf2 = new SimpleDateFormat("HH:mm:ss.SSS");
        sb.append(sdf2.format(current.getBeginTime()));
        sb.append("  ");
        for (int i = 0; i < level - 1; ++i) {
            sb.append("--");
        }
        if (level > 0) {
            sb.append("->");
        }
        Method method = current.getMethod();
        sb.append(LogThreadInterceptor.getTypeName(method.getDeclaringClass())).append('.');
        sb.append(method.getName()).append('(');
        Object[] args = current.getArguments();
        int argsLength = args.length;
        for (int i = 0; i < argsLength; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            this.writeInstance(sb, args[i]);
        }
        sb.append(")");
        int childrenSize = current.children.size();
        if (childrenSize > 0) {
            sb.append("{");
        }
        sb.append("\r\n");
        for (StackEntry se : current.children) {
            if (se.getBeginTime() == se.getEndTime()) continue;
            this.writeStackEntry(sb, root, se, level + 1);
        }
        if (childrenSize > 0) {
            sb.insert(sb.length() - 2, "}");
        }
    }

    private void writeInstance(StringBuilder sb, Object o) {
        if (o == null) {
            sb.append("null");
            return;
        }
        String className = o.getClass().getCanonicalName();
        sb.append(className);
        sb.append('{');
        if (className.indexOf("$EnhancerByCGLIB$") == -1) {
            sb.append(o);
        } else {
            sb.append("...");
        }
        sb.append('}');
    }

    private static String getTypeName(Class<?> type) {
        if (type.isArray()) {
            try {
                Class<?> cl = type;
                int dimensions = 0;
                while (cl.isArray()) {
                    ++dimensions;
                    cl = cl.getComponentType();
                }
                StringBuilder sb = new StringBuilder();
                sb.append(cl.getName());
                for (int i = 0; i < dimensions; ++i) {
                    sb.append("[]");
                }
                return sb.toString();
            }
            catch (Exception e) {
                LOGGER.warn(e.toString(), (Throwable)e);
            }
        }
        return type.getName();
    }

    private static String rightAlign(long value, int len) {
        String val = LogThreadInterceptor.newString(" ", len - String.valueOf(value).length());
        val = val + value;
        return val;
    }

    private static String newString(String value, int length) {
        StringBuilder buffer = new StringBuilder();
        if (value == null) {
            return null;
        }
        for (int i = 0; i < length; ++i) {
            buffer.append(value);
        }
        return buffer.toString();
    }

    private String retrieveProcessId() {
        if (this.cacheProcessId == null) {
            RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
            String pid = runtime.getName();
            int pos = pid.indexOf(64);
            if (pos > -1) {
                pid = pid.substring(0, pos);
            }
            this.cacheProcessId = pid;
        }
        return this.cacheProcessId;
    }

    public static class StackEntry {
        private Object thisObject;
        private Object[] arguments;
        private Method method;
        private long beginTime;
        private long endTime;
        List<StackEntry> children = new ArrayList<StackEntry>();
        StackEntry parent;

        public Object getThis() {
            return this.thisObject;
        }

        public Object[] getArguments() {
            return this.arguments;
        }

        public Method getMethod() {
            return this.method;
        }

        public long getBeginTime() {
            return this.beginTime;
        }

        public long getEndTime() {
            return this.endTime;
        }

        public List<StackEntry> getChildren() {
            return this.children;
        }

        public StackEntry getParent() {
            return this.parent;
        }

        static /* synthetic */ Object[] access$202(StackEntry x0, Object[] x1) {
            x0.arguments = x1;
            return x1;
        }
    }

    private static class StackData {
        StackEntry root;
        StackEntry currentEntry;

        private StackData() {
        }
    }
}

