/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.aoplog.support;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Constant {
    private static final Logger LOGGER = LoggerFactory.getLogger(Constant.class);
    public static final String IP = Constant.getHostAddress();
    public static final String DOMAIN = System.getProperty("weblogic.Name");
    public static final String IPFLAG = "ipflag";
    public static final String IPANDDOMAIN = Constant.getIpAndDomain();
    private static int port = 0;
    private static String hostAddress;

    private Constant() {
    }

    public static int getPort() {
        return port;
    }

    public static void setPort(int port) {
        Constant.port = port;
    }

    private static String getHostAddress() {
        if (hostAddress == null) {
            try {
                hostAddress = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException e) {
                LOGGER.warn(e.getMessage(), (Throwable)e);
            }
        }
        return hostAddress;
    }

    private static String getIpAndDomain() {
        return Constant.getHostAddress() + ":" + DOMAIN;
    }
}

