/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.aop.constant;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Locale;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AopLogConfig {
    private static final Logger log = LoggerFactory.getLogger(AopLogConfig.class);
    private static final String BUNDLE_NAME = "logAop";
    public static final String GLOBAL_TRACEID = "global-trace-id";
    public static final String PARENT_TRACEID = "parent-trace-id";
    public static final String LOCAL_TRACEID = "local-trace-id";
    public static final String USERNAME = AopLogConfig.getEnv("logAop", "loginName_Variable");
    public static final String UUID_ON_OFF = AopLogConfig.getEnv("logAop", "uuid_on_off");
    public static final String DOMAIN = System.getProperty("weblogic.Name");
    public static final String IPFLAG = "ipflag";
    private String ip;
    private int port;
    private String ipAndDomain;
    private static final AopLogConfig aopLogConfig = new AopLogConfig();

    private AopLogConfig() {
        try {
            this.ip = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            log.warn("{}", (Object)e.getMessage(), (Object)e);
        }
        if (DOMAIN != null) {
            this.ipAndDomain = this.ip + ":" + DOMAIN;
        } else {
            InetAddress addr = AopLogConfig.getLocalAddress();
            if (addr != null) {
                this.ipAndDomain = addr.toString();
            }
        }
    }

    public static AopLogConfig getInstance() {
        return aopLogConfig;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getIpAndDomain() {
        return this.ipAndDomain;
    }

    private static InetAddress getLocalAddress() {
        InetAddress addr = null;
        try {
            addr = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            log.warn("{}", (Object)e.getMessage(), (Object)e);
        }
        return addr;
    }

    private static String getEnv(String bundleName, String envName) {
        String env = ResourceBundle.getBundle(bundleName, Locale.getDefault()).getString(envName);
        if (env == null) {
            env = "";
        }
        return env;
    }
}

