/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.aop.constant;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.context.WebServerInitializedEvent;
import org.springframework.context.ApplicationListener;

public class ServerConfig
implements ApplicationListener<WebServerInitializedEvent> {
    private static final Logger log = LoggerFactory.getLogger(ServerConfig.class);
    private int serverPort;

    public int getServerPort() {
        return this.serverPort;
    }

    public String getUrl() {
        InetAddress address = null;
        try {
            address = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            log.warn("{}", (Object)e.getMessage(), (Object)e);
        }
        if (address == null) {
            return "http://localhost:" + this.serverPort;
        }
        return "http://" + address.getHostAddress() + ":" + this.serverPort;
    }

    public String getHost() {
        InetAddress address = null;
        try {
            address = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            log.warn("{}", (Object)e.getMessage(), (Object)e);
        }
        if (address == null) {
            return "localhost";
        }
        return address.getHostAddress();
    }

    public void onApplicationEvent(WebServerInitializedEvent event) {
        this.serverPort = event.getWebServer().getPort();
    }
}

