/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.aop.log.tool;

import ins.framework.aop.constant.AopLogConfig;
import ins.framework.aop.constant.AopThreadLocal;
import ins.framework.aop.constant.ServerConfig;
import ins.framework.aop.log.model.ReqModel;
import ins.framework.auth.util.JwtAuthUtil;
import ins.framework.prpins.policy.schema.vo.UserInfo;
import ins.framework.utils.Uuids;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.jboss.logging.MDC;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.context.support.SpringBeanAutowiringSupport;

public class WebAopFilter
implements Filter {
    private static final String UNKNOWN = " unknown ";
    private static final Logger LOG = LoggerFactory.getLogger((String)"AOPLOG");
    private static Map<String, String> threadData = new ConcurrentHashMap<String, String>();
    private static Map<String, Integer> threadNum = new ConcurrentHashMap<String, Integer>();
    @Autowired
    private JwtAuthUtil jwtAuthUtil;
    @Autowired
    private ServerConfig serverConfig;
    @Value(value="${spring.application.name}")
    private String serviceId;

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        String url = request.getRequestURI();
        if (url.contains(".css") || url.contains(".js") || url.contains(".png") || url.contains(".jpg")) {
            chain.doFilter(req, res);
        } else {
            if (AopLogConfig.getInstance().getPort() == 0) {
                AopLogConfig.getInstance().setPort(request.getLocalPort());
            }
            AopLogConfig.getInstance().setIp(this.getIpAddr(request));
            this.setTraceId(request);
            String userCode = "";
            String jwtHeader = request.getHeader(this.jwtAuthUtil.getHeader());
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{jwtHeader}) && jwtHeader.indexOf(46) != jwtHeader.lastIndexOf(46)) {
                userCode = this.jwtAuthUtil.getUserCode();
            }
            ReqModel model = new ReqModel(userCode, req.getRemoteAddr(), request.getRequestURI());
            AopThreadLocal.setThreadLocalRequest(model);
            AopThreadLocal.setClientid(this.getIpAddr(request));
            WebAopFilter.beforeThreadNum();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS");
            Date date = Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant());
            String startDate = sdf.format(date);
            long startTime = System.currentTimeMillis();
            chain.doFilter(req, res);
            long endTime = System.currentTimeMillis();
            long times = endTime - startTime;
            String requestUrl = "" + request.getRequestURL();
            if (request.getQueryString() != null) {
                requestUrl = request.getRequestURL() + request.getQueryString();
            }
            LOG.info("[{}] [{}] [{}] [{}] [] [{}] [{}] [{}] [{}] [{}] [{}]", new Object[]{this.getLocalHostAndPort(), this.getServiceId(), WebAopFilter.getLoginUser(), requestUrl, times, startDate, AopThreadLocal.getClientid(), AopThreadLocal.getGlobalTraceId(), AopThreadLocal.getParentTraceId(), AopThreadLocal.getLocalTraceId()});
            WebAopFilter.afterThreadNum();
        }
    }

    public void destroy() {
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        SpringBeanAutowiringSupport.processInjectionBasedOnServletContext((Object)this, (ServletContext)filterConfig.getServletContext());
    }

    private static void beforeThreadNum() {
        String threadId = WebAopFilter.getThreadId();
        if (threadNum.get(threadId) == null) {
            threadNum.put(threadId, 1);
        } else {
            threadNum.put(threadId, threadNum.get(threadId) + 1);
        }
        threadData.put(threadId + "|" + threadNum.get(threadId), WebAopFilter.getUuid());
    }

    private static void afterThreadNum() {
        String threadId = WebAopFilter.getThreadId();
        threadData.remove(threadId + "|" + threadNum.get(threadId));
        Integer itg = threadNum.get(threadId);
        if (itg != null) {
            int num = itg;
            if (num == 1) {
                threadNum.remove(threadId);
                AopThreadLocal.setAopServiceid(null);
            } else {
                threadNum.put(threadId, threadNum.get(threadId) - 1);
            }
        }
    }

    private String getServiceId() {
        return this.serviceId;
    }

    public static String getLoginUser() {
        if (AopThreadLocal.getThreadLocalRequest() != null) {
            return AopThreadLocal.getThreadLocalRequest().getUser();
        }
        return null;
    }

    public static String getLoginUserForFCCB(HttpServletRequest request) {
        if (request.getSession().getAttribute("userInfo") != null) {
            UserInfo userInfo = (UserInfo)request.getSession().getAttribute("userInfo");
            return userInfo.getUserCode();
        }
        return null;
    }

    private static String getThreadId() {
        return String.valueOf(Thread.currentThread().getId());
    }

    private String getLocalHostAndPort() {
        String localHostAndPort;
        if (AopThreadLocal.getLocalHostAndPort() != null) {
            localHostAndPort = AopThreadLocal.getLocalHostAndPort();
        } else {
            localHostAndPort = this.serverConfig.getUrl();
            AopThreadLocal.setLocalHostAndPort(localHostAndPort);
        }
        return localHostAndPort;
    }

    private static String getUuid() {
        return Uuids.shortUuid().replace("-", "");
    }

    public String getIpAddr(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.isEmpty() || UNKNOWN.equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.isEmpty() || UNKNOWN.equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.isEmpty() || UNKNOWN.equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        String[] ips = ip.split(",");
        return ips[0];
    }

    private void setTraceId(HttpServletRequest request) {
        String pParentTraceId = null;
        String pLocalTraceId = null;
        String pGlobalTraceId = request.getHeader("global-trace-id");
        if (pGlobalTraceId == null || "".equals(pGlobalTraceId.trim())) {
            pGlobalTraceId = WebAopFilter.getUuid();
            pParentTraceId = "0";
            pLocalTraceId = pGlobalTraceId;
        } else {
            pParentTraceId = request.getHeader("parent-trace-id");
            pLocalTraceId = WebAopFilter.getUuid();
        }
        AopThreadLocal.setGlobalTraceId(pGlobalTraceId);
        AopThreadLocal.setParentTraceId(pParentTraceId);
        AopThreadLocal.setLocalTraceId(pLocalTraceId);
        MDC.put((String)"pGlobalTraceId", (Object)pGlobalTraceId);
        MDC.put((String)"pParentTraceId", (Object)pParentTraceId);
        MDC.put((String)"pLocalTraceId", (Object)pLocalTraceId);
        MDC.put((String)"serviceName", (Object)this.serviceId);
    }
}

