/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.cache;

import ins.framework.cache.CacheService;
import ins.framework.cache.info.CacheManagerInfo;
import ins.framework.lang.Datas;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import net.sf.ehcache.Statistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class EhCacheCacheManager
implements CacheService {
    private static final Logger logger = LoggerFactory.getLogger(EhCacheCacheManager.class);
    private static Map<String, Object> allCacheMap = Collections.synchronizedMap(new HashMap(0));
    private String cacheName;
    private Cache cache;
    private static CacheManager cacheManager = CacheManager.getInstance();

    public EhCacheCacheManager(String cacheName) {
        this.cacheName = cacheName;
        if (!cacheManager.cacheExists(cacheName)) {
            cacheManager.addCache(cacheName);
        }
        this.cache = cacheManager.getCache(cacheName);
    }

    public static EhCacheCacheManager getInstance(String cacheManagerName) {
        if (allCacheMap.containsKey(cacheManagerName)) {
            return (EhCacheCacheManager)allCacheMap.get(cacheManagerName);
        }
        EhCacheCacheManager cacheManagerUtil = new EhCacheCacheManager(cacheManagerName);
        allCacheMap.put(cacheManagerName, cacheManagerUtil);
        return cacheManagerUtil;
    }

    @Override
    public String[] getAllCacheManagerName() {
        return EhCacheCacheManager.getAllCacheManagerNameStatic();
    }

    public static String[] getAllCacheManagerNameStatic() {
        return cacheManager.getCacheNames();
    }

    public static void clearAllCacheManagerStatic() {
        String[] cacheNameArray = cacheManager.getCacheNames();
        for (int i = 0; i < cacheNameArray.length; ++i) {
            cacheManager.getCache(cacheNameArray[i]).removeAll();
        }
    }

    @Override
    public void clearAllCacheManager() {
        EhCacheCacheManager.clearAllCacheManagerStatic();
    }

    @Override
    public Object getCache(String key) {
        Element element = this.cache.get((Serializable)((Object)key));
        Object value = null;
        if (element == null) {
            return null;
        }
        value = element.getObjectValue();
        if (logger.isDebugEnabled()) {
            logger.debug(Datas.join((Object[])new Object[]{"Retrieve data key=", key, ",value=", value}));
        }
        return value;
    }

    @Override
    public void putCache(String key, Object value) {
        Element element = new Element((Object)key, value);
        this.cache.put(element);
        if (logger.isDebugEnabled()) {
            logger.debug(Datas.join((Object[])new Object[]{"Put cache key=", key, ",value=", value}));
        }
    }

    @Override
    public void clearCache(Object ... arguments) {
        if (arguments == null || arguments.length == 0) {
            int size = this.cache.getSize();
            this.cache.removeAll();
            if (logger.isWarnEnabled()) {
                logger.warn(Datas.join((Object[])new Object[]{"Clear ", this.cacheName, " total ", size, " item(s)."}));
            }
            return;
        }
        String keyPrefix = this.generateKey(arguments);
        String keyName = "";
        Object[] keys = this.cache.getKeys().toArray();
        int size = 0;
        for (int i = 0; i < keys.length; ++i) {
            keyName = (String)keys[i];
            if (keyName == null || !keyName.startsWith(keyPrefix)) continue;
            this.cache.remove((Serializable)((Object)keyName));
            ++size;
        }
        if (logger.isWarnEnabled()) {
            logger.warn(Datas.join((Object[])new Object[]{"Clear ", this.cacheName, " ", size, " item(s).prefix=", keyPrefix}));
        }
    }

    @Override
    public boolean containsKey(String key) {
        return this.cache.isKeyInCache((Object)key);
    }

    @Override
    public boolean containsValue(String value) {
        return this.cache.isValueInCache((Object)value);
    }

    @Override
    public String generateCacheKey(Object ... arguments) {
        Assert.isTrue((arguments != null ? 1 : 0) != 0);
        Assert.isTrue((arguments.length > 0 ? 1 : 0) != 0);
        return this.generateKey(arguments);
    }

    private String generateKey(Object ... arguments) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < arguments.length - 1; ++i) {
            sb.append(arguments[i]).append(".");
        }
        sb.append(arguments[arguments.length - 1]);
        return sb.toString();
    }

    @Override
    public CacheManagerInfo getCacheManagerInfo(String cacheManagerName) {
        if (!cacheManager.cacheExists(cacheManagerName)) {
            return null;
        }
        Cache cache = cacheManager.getCache(cacheManagerName);
        CacheManagerInfo info = new CacheManagerInfo();
        info.setCacheName(cacheManagerName);
        info.setCacheType(2);
        info.setCacheImplClass(EhCacheCacheManager.class.getName());
        Statistics cacheStatistics = cache.getStatistics();
        info.setSizeInByte(cache.calculateInMemorySize());
        info.setSize(cache.getSize());
        info.setMemoryStoreSize(cache.getMemoryStoreSize());
        info.setDiskStoreSize(cache.getDiskStoreSize());
        info.setStatisticsAccuracy(cacheStatistics.getStatisticsAccuracy());
        info.setCacheHits(cacheStatistics.getCacheHits());
        info.setOnDiskHits(cacheStatistics.getOnDiskHits());
        info.setInMemoryHits(cacheStatistics.getInMemoryHits());
        info.setCacheMisses(cacheStatistics.getCacheMisses());
        info.setAverageGetTime(cacheStatistics.getAverageGetTime());
        info.setEvictionCount(cacheStatistics.getEvictionCount());
        return info;
    }

    @Override
    public void clearCacheManager(String cacheManagerName) {
        if (!cacheManager.cacheExists(cacheManagerName)) {
            return;
        }
        Cache cache = cacheManager.getCache(cacheManagerName);
        cache.removeAll();
    }

    @Override
    public int size() {
        if (this.cache == null) {
            return 0;
        }
        return this.cache.getSize();
    }

    @Override
    public Object[] getKeys() {
        return this.cache.getKeys().toArray();
    }

    @Override
    public void remove(String key) {
        this.cache.remove((Serializable)((Object)key));
    }
}

