/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.cache;

import ins.framework.cache.CacheService;
import ins.framework.cache.info.CacheManagerInfo;
import ins.framework.lang.Datas;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class HashMapCacheManager
implements CacheService {
    private static final Logger logger = LoggerFactory.getLogger(HashMapCacheManager.class);
    private static Map<String, HashMapCacheManager> allCacheMap = Collections.synchronizedMap(new HashMap(0));
    private Map<String, Object> cacheMap = Collections.synchronizedMap(new HashMap(0));
    private String cacheName;

    private HashMapCacheManager(String cacheName) {
        this.cacheName = cacheName;
    }

    public static HashMapCacheManager getInstance(String cacheManagerName) {
        HashMapCacheManager cacheManager = allCacheMap.get(cacheManagerName);
        if (cacheManager != null) {
            return cacheManager;
        }
        cacheManager = new HashMapCacheManager(cacheManagerName);
        allCacheMap.put(cacheManagerName, cacheManager);
        return cacheManager;
    }

    @Override
    public String[] getAllCacheManagerName() {
        return HashMapCacheManager.getAllCacheManagerNameStatic();
    }

    public static String[] getAllCacheManagerNameStatic() {
        String[] nameArray = new String[allCacheMap.size()];
        allCacheMap.keySet().toArray(nameArray);
        return nameArray;
    }

    public static void clearAllCacheManagerStatic() {
        String[] cacheNameArray = new String[allCacheMap.size()];
        allCacheMap.keySet().toArray(cacheNameArray);
        for (int i = 0; i < cacheNameArray.length; ++i) {
            HashMapCacheManager.getInstance(cacheNameArray[i]).clearCache(new Object[0]);
        }
    }

    @Override
    public void clearAllCacheManager() {
        HashMapCacheManager.clearAllCacheManagerStatic();
    }

    @Override
    public Object getCache(String key) {
        Object value = this.cacheMap.get(key);
        if (logger.isDebugEnabled()) {
            logger.debug(Datas.join((Object[])new Object[]{"Retrieve data key=", key, ",value=", value}));
        }
        return value;
    }

    @Override
    public void putCache(String key, Object value) {
        this.cacheMap.put(key, value);
        if (logger.isDebugEnabled()) {
            logger.debug(Datas.join((Object[])new Object[]{"Put cache key=", key, ",value=", value}));
        }
    }

    private Map<String, Object> getCacheMap() {
        return this.cacheMap;
    }

    @Override
    public void clearCache(Object ... arguments) {
        if (arguments == null || arguments.length == 0) {
            int size = this.cacheMap.size();
            this.cacheMap.clear();
            if (logger.isWarnEnabled()) {
                logger.warn(Datas.join((Object[])new Object[]{"Clear ", this.cacheName, " total ", size, " item(s)."}));
            }
            return;
        }
        String keyPrefix = this.generateKey(arguments);
        String keyName = "";
        Object[] keys = this.cacheMap.keySet().toArray();
        int size = 0;
        for (int i = 0; i < keys.length; ++i) {
            keyName = (String)keys[i];
            if (keyName == null || !keyName.startsWith(keyPrefix)) continue;
            this.cacheMap.remove(keyName);
            ++size;
        }
        if (logger.isWarnEnabled()) {
            logger.warn(Datas.join((Object[])new Object[]{"Clear ", this.cacheName, " ", size, " item(s).prefix=", keyPrefix}));
        }
    }

    @Override
    public boolean containsKey(String key) {
        return this.cacheMap.containsKey(key);
    }

    @Override
    public boolean containsValue(String value) {
        return this.cacheMap.containsValue(value);
    }

    @Override
    public String generateCacheKey(Object ... arguments) {
        Assert.isTrue((arguments != null ? 1 : 0) != 0);
        Assert.isTrue((arguments.length > 0 ? 1 : 0) != 0);
        return this.generateKey(arguments);
    }

    private String generateKey(Object ... arguments) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < arguments.length - 1; ++i) {
            sb.append(arguments[i]).append(".");
        }
        sb.append(arguments[arguments.length - 1]);
        return sb.toString();
    }

    @Override
    public CacheManagerInfo getCacheManagerInfo(String cacheManagerName) {
        return HashMapCacheManager.getCacheManagerInfoStatic(cacheManagerName);
    }

    public static CacheManagerInfo getCacheManagerInfoStatic(String cacheManagerName) {
        if (!allCacheMap.containsKey(cacheManagerName)) {
            return null;
        }
        HashMapCacheManager cache = HashMapCacheManager.getInstance(cacheManagerName);
        CacheManagerInfo info = new CacheManagerInfo();
        info.setCacheName(cacheManagerName);
        info.setCacheType(1);
        info.setCacheImplClass(HashMapCacheManager.class.getName());
        info.setSize(cache.getCacheMap().size());
        info.setMemoryStoreSize(cache.getCacheMap().size());
        info.setDiskStoreSize(0L);
        info.setStatisticsAccuracy(-1);
        info.setCacheHits(-1L);
        info.setOnDiskHits(-1L);
        info.setInMemoryHits(-1L);
        info.setCacheMisses(-1L);
        info.setAverageGetTime(-1.0f);
        info.setEvictionCount(-1L);
        return info;
    }

    @Override
    public void clearCacheManager(String cacheManagerName) {
        if (allCacheMap.containsKey(cacheManagerName)) {
            HashMapCacheManager.getInstance(cacheManagerName).clearCache(new Object[0]);
        }
    }

    @Override
    public int size() {
        if (this.cacheMap == null) {
            return 0;
        }
        return this.cacheMap.size();
    }

    @Override
    public Object[] getKeys() {
        return this.cacheMap.keySet().toArray();
    }

    @Override
    public void remove(String key) {
        this.cacheMap.remove(key);
    }
}

