/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.cache;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import ins.framework.cache.CacheService;
import ins.framework.cache.info.CacheManagerInfo;
import ins.framework.cache.redis.JedisPoolFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import redis.clients.jedis.ShardedJedis;
import redis.clients.util.Pool;

public class RedisCacheManager
implements CacheService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RedisCacheManager.class);
    public static Pool<ShardedJedis> pool = null;
    private static Map<String, RedisCacheManager> allCacheMap = Collections.synchronizedMap(new HashMap(0));
    private String cacheName;
    private static final String ALL_CACHE_MANAGER = "AllCacheManager";
    private static SerializerFeature[] FEATURES = new SerializerFeature[]{SerializerFeature.WriteClassName, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteNullListAsEmpty, SerializerFeature.WriteNullNumberAsZero, SerializerFeature.WriteNullBooleanAsFalse, SerializerFeature.WriteNullStringAsEmpty};

    private RedisCacheManager(String cacheName) {
        this.cacheName = cacheName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RedisCacheManager getInstance(String cacheManagerName) {
        RedisCacheManager cacheManager = allCacheMap.get(cacheManagerName);
        if (cacheManager != null) {
            return cacheManager;
        }
        cacheManager = new RedisCacheManager(cacheManagerName);
        allCacheMap.put(cacheManagerName, cacheManager);
        ShardedJedis jedis = null;
        try {
            jedis = (ShardedJedis)pool.getResource();
            Set keys = jedis.smembers(ALL_CACHE_MANAGER);
            if (keys.isEmpty()) {
                LOGGER.debug("Can't find {},Create one with cache[{}].", (Object)ALL_CACHE_MANAGER, (Object)cacheManagerName);
                jedis.sadd(ALL_CACHE_MANAGER, new String[]{cacheManagerName});
            } else {
                LOGGER.debug("Find {} with {} items.", (Object)ALL_CACHE_MANAGER, (Object)keys.size());
                if (!keys.contains(cacheManagerName)) {
                    LOGGER.debug("Add cache[{}] into {}.", (Object)cacheManagerName, (Object)ALL_CACHE_MANAGER);
                    jedis.sadd(ALL_CACHE_MANAGER, new String[]{cacheManagerName});
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn("{}", (Throwable)e);
        }
        finally {
            if (jedis != null) {
                pool.returnResource((Object)jedis);
            }
        }
        return cacheManager;
    }

    @Override
    public String[] getAllCacheManagerName() {
        return RedisCacheManager.getAllCacheManagerNameStatic();
    }

    public static String[] getAllCacheManagerNameStatic() {
        String[] nameArray = new String[allCacheMap.size()];
        allCacheMap.keySet().toArray(nameArray);
        return nameArray;
    }

    public static void clearAllCacheManagerStatic() {
        String[] cacheNameArray = new String[allCacheMap.size()];
        allCacheMap.keySet().toArray(cacheNameArray);
        for (int i = 0; i < cacheNameArray.length; ++i) {
            LOGGER.debug("Clear cacheManager {}", (Object)cacheNameArray[i]);
            RedisCacheManager.getInstance(cacheNameArray[i]).clearCache(new Object[0]);
        }
    }

    @Override
    public void clearAllCacheManager() {
        RedisCacheManager.clearAllCacheManagerStatic();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getCache(String key) {
        Object result = null;
        ShardedJedis jedis = null;
        try {
            jedis = (ShardedJedis)pool.getResource();
            result = JSON.parse((String)jedis.hget(this.cacheName, this.generateCacheKey(key)));
            LOGGER.debug("Retrieve data key={},value={}", (Object)key, result);
        }
        catch (Exception e) {
            LOGGER.warn("{}", (Throwable)e);
        }
        finally {
            if (jedis != null) {
                pool.returnResource((Object)jedis);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putCache(String key, Object value) {
        ShardedJedis jedis = null;
        try {
            jedis = (ShardedJedis)pool.getResource();
            jedis.hset(this.cacheName, this.generateCacheKey(key), JSON.toJSONString((Object)value, (SerializerFeature[])FEATURES));
            LOGGER.debug("Put cache key={},value={}", (Object)key, value);
        }
        catch (Exception e) {
            LOGGER.warn("{}", (Throwable)e);
        }
        finally {
            if (jedis != null) {
                pool.returnResource((Object)jedis);
            }
        }
    }

    private Map<String, Object> getCacheMap() {
        return new HashMap<String, Object>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCache(Object ... arguments) {
        ShardedJedis jedis = null;
        try {
            jedis = (ShardedJedis)pool.getResource();
            if (arguments == null || arguments.length == 0) {
                long ss = jedis.del(this.cacheName);
                LOGGER.warn("Clear 1 cache[{}] with {} item(s).", (Object)this.cacheName, (Object)ss);
                return;
            }
            Set keys = jedis.hkeys(this.cacheName);
            String keyPrefix = this.generateKey(arguments);
            int size = 0;
            for (String key : keys) {
                if (!key.startsWith(keyPrefix)) continue;
                jedis.hdel(this.cacheName, new String[]{key});
                ++size;
            }
            LOGGER.warn("Clear cache[{}] with {} item(s).prefix is [{}]", new Object[]{this.cacheName, size, keyPrefix});
        }
        catch (Exception e) {
            LOGGER.warn("{}", (Throwable)e);
        }
        finally {
            if (jedis != null) {
                pool.returnResource((Object)jedis);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(String key) {
        boolean result = false;
        ShardedJedis jedis = null;
        try {
            jedis = (ShardedJedis)pool.getResource();
            result = jedis.hexists(this.cacheName, key);
        }
        catch (Exception e) {
            LOGGER.warn("{}", (Throwable)e);
        }
        finally {
            if (jedis != null) {
                pool.returnResource((Object)jedis);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsValue(String value) {
        if (value == null) {
            return false;
        }
        boolean result = false;
        ShardedJedis jedis = null;
        try {
            jedis = (ShardedJedis)pool.getResource();
            List vals = jedis.hvals(this.cacheName);
            for (String val : vals) {
                if (!value.equals(JSON.parse((String)val))) continue;
                result = true;
                break;
            }
        }
        catch (Exception e) {
            LOGGER.warn("{}", (Throwable)e);
        }
        finally {
            if (jedis != null) {
                pool.returnResource((Object)jedis);
            }
        }
        return result;
    }

    @Override
    public String generateCacheKey(Object ... arguments) {
        Assert.isTrue((arguments != null ? 1 : 0) != 0);
        Assert.isTrue((arguments.length > 0 ? 1 : 0) != 0);
        return this.generateKey(arguments);
    }

    private String generateKey(Object ... arguments) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < arguments.length - 1; ++i) {
            sb.append(arguments[i]).append(":");
        }
        sb.append(arguments[arguments.length - 1]);
        return sb.toString();
    }

    @Override
    public CacheManagerInfo getCacheManagerInfo(String cacheManagerName) {
        return RedisCacheManager.getCacheManagerInfoStatic(cacheManagerName);
    }

    public static CacheManagerInfo getCacheManagerInfoStatic(String cacheManagerName) {
        if (!allCacheMap.containsKey(cacheManagerName)) {
            return null;
        }
        RedisCacheManager cache = RedisCacheManager.getInstance(cacheManagerName);
        CacheManagerInfo info = new CacheManagerInfo();
        info.setCacheName(cacheManagerName);
        info.setCacheType(1);
        info.setCacheImplClass(RedisCacheManager.class.getName());
        info.setSize(cache.getCacheMap().size());
        info.setMemoryStoreSize(cache.getCacheMap().size());
        info.setDiskStoreSize(0L);
        info.setStatisticsAccuracy(-1);
        info.setCacheHits(-1L);
        info.setOnDiskHits(-1L);
        info.setInMemoryHits(-1L);
        info.setCacheMisses(-1L);
        info.setAverageGetTime(-1.0f);
        info.setEvictionCount(-1L);
        return info;
    }

    @Override
    public void clearCacheManager(String cacheManagerName) {
        if (allCacheMap.containsKey(cacheManagerName)) {
            RedisCacheManager.getInstance(cacheManagerName).clearCache(new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        int totolSize = 0;
        ShardedJedis jedis = null;
        try {
            jedis = (ShardedJedis)pool.getResource();
            totolSize = jedis.hlen(this.cacheName).intValue();
        }
        catch (Exception e) {
            LOGGER.warn("{}", (Throwable)e);
        }
        finally {
            if (jedis != null) {
                pool.returnResource((Object)jedis);
            }
        }
        LOGGER.debug("Cache[{}] has {} items.", (Object)this.cacheName, (Object)totolSize);
        return totolSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] getKeys() {
        Object[] keyArray = new Object[]{};
        ShardedJedis jedis = null;
        try {
            jedis = (ShardedJedis)pool.getResource();
            Set keys = jedis.hkeys(this.cacheName);
            keyArray = new Object[keys.size()];
            int index = 0;
            for (String key : keys) {
                keyArray[index++] = key;
            }
        }
        catch (Exception e) {
            LOGGER.warn("{}", (Throwable)e);
        }
        finally {
            if (jedis != null) {
                pool.returnResource((Object)jedis);
            }
        }
        return keyArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(String key) {
        ShardedJedis jedis = null;
        try {
            jedis = (ShardedJedis)pool.getResource();
            jedis.hdel(this.cacheName, new String[]{this.generateCacheKey(key)});
        }
        catch (Exception e) {
            LOGGER.warn("{}", (Throwable)e);
        }
        finally {
            if (jedis != null) {
                pool.returnResource((Object)jedis);
            }
        }
    }

    static {
        try {
            pool = JedisPoolFactory.createJedisPool();
        }
        catch (Exception e) {
            pool = null;
        }
    }
}

