/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.cache.ehcache;

import ins.framework.lang.Datas;
import java.util.Properties;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.event.CacheEventListener;
import net.sf.ehcache.event.CacheEventListenerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogCacheEventListenerFactory
extends CacheEventListenerFactory {
    private static final Logger logger = LoggerFactory.getLogger(LogCacheEventListenerFactory.class);

    public CacheEventListener createCacheEventListener(Properties properties) {
        return new CacheEventListener(){

            public void dispose() {
            }

            public void notifyElementEvicted(Ehcache cache, Element element) {
                if (logger.isInfoEnabled()) {
                    logger.info(Datas.join((Object[])new Object[]{"Element ", element.getKey(), "=", element.getValue(), " evicted."}));
                }
            }

            public void notifyElementExpired(Ehcache cache, Element element) {
                if (logger.isInfoEnabled()) {
                    logger.info(Datas.join((Object[])new Object[]{"Element ", element.getKey(), "=", element.getValue(), " expired."}));
                }
            }

            public void notifyElementPut(Ehcache cache, Element element) throws CacheException {
                if (logger.isInfoEnabled()) {
                    logger.info(Datas.join((Object[])new Object[]{"Element ", element.getKey(), "=", element.getValue(), " added."}));
                }
            }

            public void notifyElementRemoved(Ehcache cache, Element element) throws CacheException {
                if (logger.isInfoEnabled()) {
                    logger.info(Datas.join((Object[])new Object[]{"Element ", element.getKey(), "=", element.getValue(), " removed."}));
                }
            }

            public void notifyElementUpdated(Ehcache cache, Element element) throws CacheException {
                if (logger.isInfoEnabled()) {
                    logger.info(Datas.join((Object[])new Object[]{"Element ", element.getKey(), "=", element.getValue(), " updated."}));
                }
            }

            public void notifyRemoveAll(Ehcache cache) {
                if (logger.isWarnEnabled()) {
                    logger.warn(Datas.join((Object[])new Object[]{cache.getName(), " remove all."}));
                }
            }

            public Object clone() throws CloneNotSupportedException {
                return super.clone();
            }
        };
    }
}

