/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.cache.redis;

import ins.framework.cache.redis.ShardedJedisSentinelPool;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.JedisShardInfo;
import redis.clients.jedis.ShardedJedis;
import redis.clients.jedis.ShardedJedisPool;
import redis.clients.util.Pool;

public class JedisPoolFactory {
    private static final ResourceBundle resources = ResourceBundle.getBundle("redis");
    private static int DEFAULT_MAX_ACTIVE = 60;
    private static int DEFAULT_MAXIDLE = 30;
    private static int DEFAULT_MAXWAIT = 100;
    private static boolean DEFAULT_TESTONBORROW = false;
    private static String DEFAULT_REDIS_FLAG = "off";

    private static GenericObjectPoolConfig getConfig() {
        try {
            DEFAULT_MAX_ACTIVE = Integer.parseInt(resources.getString("redis.pool.maxActive"));
            DEFAULT_MAXIDLE = Integer.parseInt(resources.getString("redis.pool.maxIdle"));
            DEFAULT_MAXWAIT = Integer.parseInt(resources.getString("redis.pool.maxWait"));
            DEFAULT_TESTONBORROW = Boolean.valueOf(resources.getString("redis.pool.testOnBorrow"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        GenericObjectPoolConfig config = new GenericObjectPoolConfig();
        config.setMaxTotal(DEFAULT_MAX_ACTIVE);
        config.setMaxIdle(DEFAULT_MAXIDLE);
        config.setMaxWaitMillis((long)DEFAULT_MAXWAIT);
        config.setTestOnBorrow(DEFAULT_TESTONBORROW);
        return config;
    }

    private static List<JedisShardInfo> getShardInfoList() {
        ArrayList<JedisShardInfo> shardInfoList = new ArrayList<JedisShardInfo>();
        String host = resources.getString("redis.master.host");
        String port = resources.getString("redis.master.port");
        String[] hostArr = host.split("/");
        String[] portArr = port.split("/");
        for (int i = 0; i < hostArr.length; ++i) {
            shardInfoList.add(new JedisShardInfo(hostArr[i].trim(), Integer.parseInt(portArr[i].trim()), 60000));
        }
        return shardInfoList;
    }

    private static List<String> getMasterNameList() {
        ArrayList<String> masterList = new ArrayList<String>();
        String name = resources.getString("redis.master.name");
        String[] nameArr = name.split("/");
        for (int i = 0; i < nameArr.length; ++i) {
            masterList.add(nameArr[i].trim());
        }
        return masterList;
    }

    private static Set<String> getSentinelAddressList() {
        HashSet<String> sentinelList = new HashSet<String>();
        String address = resources.getString("redis.sentinel.address");
        String[] addressArr = address.split("/");
        for (int i = 0; i < addressArr.length; ++i) {
            sentinelList.add(addressArr[i].trim());
        }
        return sentinelList;
    }

    public static Pool<ShardedJedis> createJedisPool() {
        Object pool = null;
        try {
            DEFAULT_REDIS_FLAG = resources.getString("redis").trim();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if ("on".equals(DEFAULT_REDIS_FLAG)) {
            String runMode = resources.getString("redis.runMode").trim();
            if ("1".equals(runMode)) {
                List<JedisShardInfo> shardList = JedisPoolFactory.getShardInfoList();
                pool = new ShardedJedisPool(JedisPoolFactory.getConfig(), shardList);
            } else if ("2".equals(runMode)) {
                List<String> masterList = JedisPoolFactory.getMasterNameList();
                Set<String> sentinelList = JedisPoolFactory.getSentinelAddressList();
                pool = new ShardedJedisSentinelPool(masterList, sentinelList, JedisPoolFactory.getConfig(), 60000);
            }
        }
        return pool;
    }
}

