/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.cache.redis;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPubSub;
import redis.clients.jedis.JedisShardInfo;
import redis.clients.jedis.ShardedJedis;
import redis.clients.jedis.exceptions.JedisConnectionException;
import redis.clients.util.Hashing;
import redis.clients.util.Pool;

public class ShardedJedisSentinelPool
extends Pool<ShardedJedis> {
    public static final int MAX_RETRY_SENTINEL = 10;
    protected final Logger log = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    protected GenericObjectPoolConfig poolConfig;
    protected int timeout = 2000;
    private int sentinelRetry = 0;
    protected String password;
    protected int database = 0;
    protected Set<MasterListener> masterListeners = new HashSet<MasterListener>();
    private volatile List<HostAndPort> currentHostMasters;

    public ShardedJedisSentinelPool(List<String> masters, Set<String> sentinels) {
        this(masters, sentinels, new GenericObjectPoolConfig(), 2000, null, 0);
    }

    public ShardedJedisSentinelPool(List<String> masters, Set<String> sentinels, String password) {
        this(masters, sentinels, new GenericObjectPoolConfig(), 2000, password);
    }

    public ShardedJedisSentinelPool(GenericObjectPoolConfig poolConfig, List<String> masters, Set<String> sentinels) {
        this(masters, sentinels, poolConfig, 2000, null, 0);
    }

    public ShardedJedisSentinelPool(List<String> masters, Set<String> sentinels, GenericObjectPoolConfig poolConfig, int timeout, String password) {
        this(masters, sentinels, poolConfig, timeout, password, 0);
    }

    public ShardedJedisSentinelPool(List<String> masters, Set<String> sentinels, GenericObjectPoolConfig poolConfig, int timeout) {
        this(masters, sentinels, poolConfig, timeout, null, 0);
    }

    public ShardedJedisSentinelPool(List<String> masters, Set<String> sentinels, GenericObjectPoolConfig poolConfig, String password) {
        this(masters, sentinels, poolConfig, 2000, password);
    }

    public ShardedJedisSentinelPool(List<String> masters, Set<String> sentinels, GenericObjectPoolConfig poolConfig, int timeout, String password, int database) {
        this.poolConfig = poolConfig;
        this.timeout = timeout;
        this.password = password;
        this.database = database;
        List<HostAndPort> masterList = this.initSentinels(sentinels, masters);
        this.initPool(masterList);
    }

    public void destroy() {
        for (MasterListener m : this.masterListeners) {
            m.shutdown();
        }
        super.destroy();
    }

    public List<HostAndPort> getCurrentHostMaster() {
        return this.currentHostMasters;
    }

    private void initPool(List<HostAndPort> masters) {
        if (!this.equals(this.currentHostMasters, masters)) {
            StringBuffer sb = new StringBuffer();
            for (HostAndPort master : masters) {
                sb.append(master.toString());
                sb.append(" ");
            }
            this.log.info("Created ShardedJedisPool to master at [" + sb.toString().trim() + "]");
            List<JedisShardInfo> shardMasters = this.makeShardInfoList(masters);
            this.initPool(this.poolConfig, new ShardedJedisFactory(shardMasters, Hashing.MURMUR_HASH, null));
            this.currentHostMasters = masters;
        }
    }

    private boolean equals(List<HostAndPort> currentShardMasters, List<HostAndPort> shardMasters) {
        if (currentShardMasters != null && shardMasters != null && currentShardMasters.size() == shardMasters.size()) {
            for (int i = 0; i < currentShardMasters.size(); ++i) {
                if (currentShardMasters.get(i).equals((Object)shardMasters.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private List<JedisShardInfo> makeShardInfoList(List<HostAndPort> masters) {
        ArrayList<JedisShardInfo> shardMasters = new ArrayList<JedisShardInfo>();
        for (HostAndPort master : masters) {
            JedisShardInfo jedisShardInfo = new JedisShardInfo(master.getHost(), master.getPort(), this.timeout);
            jedisShardInfo.setPassword(this.password);
            shardMasters.add(jedisShardInfo);
        }
        return shardMasters;
    }

    private List<HostAndPort> initSentinels(Set<String> sentinels, List<String> masters) {
        HashMap<String, HostAndPort> masterMap = new HashMap<String, HostAndPort>();
        ArrayList<HostAndPort> shardMasters = new ArrayList<HostAndPort>();
        this.log.info("Trying to find all master from available Sentinels...");
        for (String masterName : masters) {
            HostAndPort master = null;
            boolean fetched = false;
            while (!fetched && this.sentinelRetry < 10) {
                for (String sentinel : sentinels) {
                    HostAndPort hap = this.toHostAndPort(Arrays.asList(sentinel.split(":")));
                    this.log.fine("Connecting to Sentinel " + hap);
                    try {
                        List hostAndPort;
                        Jedis jedis = new Jedis(hap.getHost(), hap.getPort());
                        master = (HostAndPort)masterMap.get(masterName);
                        if (master != null || (hostAndPort = jedis.sentinelGetMasterAddrByName(masterName)) == null || hostAndPort.size() <= 0) continue;
                        master = this.toHostAndPort(hostAndPort);
                        this.log.fine("Found Redis master at " + master);
                        shardMasters.add(master);
                        masterMap.put(masterName, master);
                        fetched = true;
                        jedis.disconnect();
                        break;
                    }
                    catch (JedisConnectionException e) {
                        this.log.warning("Cannot connect to sentinel running @ " + hap + ". Trying next one.");
                    }
                }
                if (null != master) continue;
                try {
                    this.log.severe("All sentinels down, cannot determine where is " + masterName + " master is running... sleeping 1000ms, Will try again.");
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                fetched = false;
                ++this.sentinelRetry;
            }
            if (fetched || this.sentinelRetry < 10) continue;
            this.log.severe("All sentinels down and try 10 times, Abort.");
            throw new JedisConnectionException("Cannot connect all sentinels, Abort.");
        }
        if (masters.size() != 0 && masters.size() == shardMasters.size()) {
            this.log.info("Starting Sentinel listeners...");
            for (String sentinel : sentinels) {
                HostAndPort hap = this.toHostAndPort(Arrays.asList(sentinel.split(":")));
                MasterListener masterListener = new MasterListener(masters, hap.getHost(), hap.getPort());
                this.masterListeners.add(masterListener);
                masterListener.start();
            }
        }
        return shardMasters;
    }

    private HostAndPort toHostAndPort(List<String> getMasterAddrByNameResult) {
        String host = getMasterAddrByNameResult.get(0);
        int port = Integer.parseInt(getMasterAddrByNameResult.get(1));
        return new HostAndPort(host, port);
    }

    protected class MasterListener
    extends Thread {
        protected List<String> masters;
        protected String host;
        protected int port;
        protected long subscribeRetryWaitTimeMillis = 5000L;
        protected Jedis jedis;
        protected AtomicBoolean running = new AtomicBoolean(false);

        protected MasterListener() {
        }

        public MasterListener(List<String> masters, String host, int port) {
            this.masters = masters;
            this.host = host;
            this.port = port;
        }

        public MasterListener(List<String> masters, String host, int port, long subscribeRetryWaitTimeMillis) {
            this(masters, host, port);
            this.subscribeRetryWaitTimeMillis = subscribeRetryWaitTimeMillis;
        }

        @Override
        public void run() {
            this.running.set(true);
            while (this.running.get()) {
                this.jedis = new Jedis(this.host, this.port);
                try {
                    this.jedis.subscribe((JedisPubSub)new JedisPubSubAdapter(){

                        @Override
                        public void onMessage(String channel, String message) {
                            ShardedJedisSentinelPool.this.log.fine("Sentinel " + MasterListener.this.host + ":" + MasterListener.this.port + " published: " + message + ".");
                            String[] switchMasterMsg = message.split(" ");
                            if (switchMasterMsg.length > 3) {
                                int index = MasterListener.this.masters.indexOf(switchMasterMsg[0]);
                                if (index >= 0) {
                                    HostAndPort newHostMaster = ShardedJedisSentinelPool.this.toHostAndPort(Arrays.asList(switchMasterMsg[3], switchMasterMsg[4]));
                                    ArrayList<HostAndPort> newHostMasters = new ArrayList<HostAndPort>();
                                    for (int i = 0; i < MasterListener.this.masters.size(); ++i) {
                                        newHostMasters.add(null);
                                    }
                                    Collections.copy(newHostMasters, ShardedJedisSentinelPool.this.currentHostMasters);
                                    newHostMasters.set(index, newHostMaster);
                                    ShardedJedisSentinelPool.this.initPool(newHostMasters);
                                } else {
                                    StringBuffer sb = new StringBuffer();
                                    for (String masterName : MasterListener.this.masters) {
                                        sb.append(masterName);
                                        sb.append(",");
                                    }
                                    ShardedJedisSentinelPool.this.log.fine("Ignoring message on +switch-master for master name " + switchMasterMsg[0] + ", our monitor master name are [" + sb + "]");
                                }
                            } else {
                                ShardedJedisSentinelPool.this.log.severe("Invalid message received on Sentinel " + MasterListener.this.host + ":" + MasterListener.this.port + " on channel +switch-master: " + message);
                            }
                        }
                    }, new String[]{"+switch-master"});
                }
                catch (JedisConnectionException e) {
                    if (this.running.get()) {
                        ShardedJedisSentinelPool.this.log.severe("Lost connection to Sentinel at " + this.host + ":" + this.port + ". Sleeping 5000ms and retrying.");
                        try {
                            Thread.sleep(this.subscribeRetryWaitTimeMillis);
                        }
                        catch (InterruptedException e1) {
                            e1.printStackTrace();
                        }
                        continue;
                    }
                    ShardedJedisSentinelPool.this.log.fine("Unsubscribing from Sentinel at " + this.host + ":" + this.port);
                }
            }
        }

        public void shutdown() {
            try {
                ShardedJedisSentinelPool.this.log.fine("Shutting down listener on " + this.host + ":" + this.port);
                this.running.set(false);
                this.jedis.disconnect();
            }
            catch (Exception e) {
                ShardedJedisSentinelPool.this.log.severe("Caught exception while shutting down: " + e.getMessage());
            }
        }
    }

    protected class JedisPubSubAdapter
    extends JedisPubSub {
        protected JedisPubSubAdapter() {
        }

        public void onMessage(String channel, String message) {
        }

        public void onPMessage(String pattern, String channel, String message) {
        }

        public void onPSubscribe(String pattern, int subscribedChannels) {
        }

        public void onPUnsubscribe(String pattern, int subscribedChannels) {
        }

        public void onSubscribe(String channel, int subscribedChannels) {
        }

        public void onUnsubscribe(String channel, int subscribedChannels) {
        }
    }

    protected static class ShardedJedisFactory
    implements PooledObjectFactory<ShardedJedis> {
        private List<JedisShardInfo> shards;
        private Hashing algo;
        private Pattern keyTagPattern;

        public ShardedJedisFactory(List<JedisShardInfo> shards, Hashing algo, Pattern keyTagPattern) {
            this.shards = shards;
            this.algo = algo;
            this.keyTagPattern = keyTagPattern;
        }

        public PooledObject<ShardedJedis> makeObject() throws Exception {
            ShardedJedis jedis = new ShardedJedis(this.shards, this.algo, this.keyTagPattern);
            return new DefaultPooledObject((Object)jedis);
        }

        public void destroyObject(PooledObject<ShardedJedis> pooledShardedJedis) throws Exception {
            ShardedJedis shardedJedis = (ShardedJedis)pooledShardedJedis.getObject();
            for (Jedis jedis : shardedJedis.getAllShards()) {
                try {
                    try {
                        jedis.quit();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    jedis.disconnect();
                }
                catch (Exception e) {}
            }
        }

        public boolean validateObject(PooledObject<ShardedJedis> pooledShardedJedis) {
            try {
                ShardedJedis jedis = (ShardedJedis)pooledShardedJedis.getObject();
                for (Jedis shard : jedis.getAllShards()) {
                    if (shard.ping().equals("PONG")) continue;
                    return false;
                }
                return true;
            }
            catch (Exception ex) {
                return false;
            }
        }

        public void activateObject(PooledObject<ShardedJedis> p) throws Exception {
        }

        public void passivateObject(PooledObject<ShardedJedis> p) throws Exception {
        }
    }
}

