/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.cache;

import java.lang.reflect.Method;
import org.springframework.cache.annotation.CachingConfigurerSupport;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.cache.interceptor.KeyGenerator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.PropertySource;

@EnableCaching
@PropertySource(value={"classpath:/cache-default.properties"})
public class CacheConfig
extends CachingConfigurerSupport {
    private static final int DEFAULT_BUFFER_SIZE = 128;

    @Bean
    public KeyGenerator keyGenerator() {
        return CacheConfig::generateKey;
    }

    private static Object generateKey(Object target, Method method, Object ... params) {
        StringBuilder sb = new StringBuilder(128);
        sb.append(target.getClass().getName());
        sb.append('.');
        sb.append(method.getName());
        for (Object obj : params) {
            sb.append('.');
            sb.append(obj.toString());
        }
        return sb.toString();
    }
}

