/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.cloud.config;

import ins.framework.aop.constant.AopThreadLocal;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.MultiValueMap;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class RestTemplateInterceptor
implements ClientHttpRequestInterceptor {
    private static final Logger log = LoggerFactory.getLogger(RestTemplateInterceptor.class);
    private static final String AUTHORIZATION_HEADER = "Authorization";
    private static final String SHARDING_KEY = "shardingKey";

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        this.tranceRequest((ClientHttpRequest)request, body);
        ClientHttpResponse response = execution.execute(request, body);
        return response;
    }

    private void tranceRequest(ClientHttpRequest request, byte[] body) throws UnsupportedEncodingException {
        String globalTraceId;
        String authorization;
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes == null) {
            return;
        }
        HttpServletRequest req = ((ServletRequestAttributes)requestAttributes).getRequest();
        HttpHeaders headers = new HttpHeaders();
        String shardingKey = req.getHeader(SHARDING_KEY);
        if (shardingKey != null) {
            headers.add(SHARDING_KEY, shardingKey);
        }
        if ((authorization = req.getHeader(AUTHORIZATION_HEADER)) != null) {
            headers.add(AUTHORIZATION_HEADER, authorization);
        }
        if ((globalTraceId = req.getHeader("global-trace-id")) == null) {
            headers.add("global-trace-id", AopThreadLocal.getGlobalTraceId());
        } else {
            headers.add("global-trace-id", globalTraceId);
        }
        String parentTraceId = req.getHeader("local-trace-id");
        if (parentTraceId == null) {
            headers.add("parent-trace-id", AopThreadLocal.getLocalTraceId());
        } else {
            headers.add("parent-trace-id", parentTraceId);
        }
        request.getHeaders().addAll((MultiValueMap)headers);
    }
}

