/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.cloud.feign.codec;

import com.google.gson.Gson;
import feign.Response;
import feign.Util;
import feign.codec.ErrorDecoder;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeepMessageErrorDecoder
implements ErrorDecoder {
    private static final Logger log = LoggerFactory.getLogger(KeepMessageErrorDecoder.class);
    private static final Gson GSON = new Gson();

    public Exception decode(String methodKey, Response response) {
        Exception exception = null;
        try {
            String json = Util.toString((Reader)response.body().asReader());
            String message = "";
            if (StringUtils.isNotBlank((CharSequence)json)) {
                Map exceptionMap = (Map)GSON.fromJson(json, Map.class);
                message = (String)exceptionMap.get("message");
            }
            if (StringUtils.isBlank((CharSequence)message)) {
                message = "";
            }
            exception = new RuntimeException(message);
        }
        catch (IOException ex) {
            log.error("{}", (Object)ex.getMessage(), (Object)ex);
            exception = new ErrorDecoder.Default().decode(methodKey, response);
        }
        log.debug("KeepMessageErrorDecoder {}", (Throwable)exception);
        return exception;
    }
}

