/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.cloud.feign.codec;

import com.netflix.hystrix.exception.HystrixBadRequestException;
import feign.Response;
import feign.Util;
import feign.codec.ErrorDecoder;
import java.io.IOException;
import java.io.Reader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotBreakErrorDecoder
implements ErrorDecoder {
    private static final Logger log = LoggerFactory.getLogger(NotBreakErrorDecoder.class);

    public Exception decode(String methodKey, Response response) {
        Object exception = null;
        try {
            String json = Util.toString((Reader)response.body().asReader());
            exception = new HystrixBadRequestException(json);
        }
        catch (IOException ex) {
            log.error("{}", (Object)ex.getMessage(), (Object)ex);
            exception = new ErrorDecoder.Default().decode(methodKey, response);
        }
        log.debug("NotBreakErrorDecoder {}", (Throwable)exception);
        return exception;
    }
}

