/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.cloud.util;

import ins.framework.aop.constant.AopThreadLocal;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public final class CloudThreadPools {
    private static final Logger log = LoggerFactory.getLogger(CloudThreadPools.class);
    private static final int KEEP_ALIVE_TIME = 600;
    private static ExecutorService exec = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 600L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
    private static final String AUTHORIZATION_HEADER = "Authorization";
    private static final String SHARDING_KEY = "shardingKey";
    private static final String GLOBAL_TRACE_ID = "global-trace-id";
    private static final String PARENT_TRACE_ID = "parent-trace-id";
    private static final String TSF_TAGS = "tsf-tags";

    private CloudThreadPools() {
    }

    public static void exec(Runnable task) {
        exec.submit(TaskFactory.build(task));
    }

    public static <T> Future<T> exec(Callable<T> task) {
        return exec.submit(TaskFactory.build(task));
    }

    public static class WrappedCallable<T>
    implements Callable<T> {
        private final Callable<T> target;
        private final Map<String, Object> params;

        public WrappedCallable(Callable<T> target, Map<String, Object> params) {
            this.target = target;
            this.params = params;
        }

        @Override
        public T call() throws Exception {
            TaskFactory.deliveryHeades(this.params);
            return this.target.call();
        }
    }

    public static class WrappedRunnable
    implements Runnable {
        private final Runnable target;
        private final Map<String, Object> params;

        public WrappedRunnable(Runnable target, Map<String, Object> params) {
            this.target = target;
            this.params = params;
        }

        @Override
        public void run() {
            TaskFactory.deliveryHeades(this.params);
            this.target.run();
        }
    }

    public static class TaskFactory {
        private TaskFactory() {
        }

        private static Map<String, Object> getParams() {
            HashMap<String, Object> params = new HashMap<String, Object>();
            ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
            if (requestAttributes != null) {
                HttpServletRequest request = requestAttributes.getRequest();
                Object tsfTags = requestAttributes.getAttribute(CloudThreadPools.TSF_TAGS, 0);
                String authorization = request.getHeader(CloudThreadPools.AUTHORIZATION_HEADER);
                String shardingKey = request.getHeader(CloudThreadPools.SHARDING_KEY);
                String globalTraceId = AopThreadLocal.getGlobalTraceId();
                String parentTraceId = AopThreadLocal.getLocalTraceId();
                params.put(CloudThreadPools.AUTHORIZATION_HEADER, authorization);
                params.put(CloudThreadPools.TSF_TAGS, tsfTags);
                params.put(CloudThreadPools.GLOBAL_TRACE_ID, globalTraceId);
                params.put(CloudThreadPools.PARENT_TRACE_ID, parentTraceId);
                params.put(CloudThreadPools.SHARDING_KEY, shardingKey);
            }
            return params;
        }

        public static <T> Callable<T> build(Callable<T> task) {
            return new WrappedCallable<T>(task, TaskFactory.getParams());
        }

        public static Runnable build(Runnable task) {
            return new WrappedRunnable(task, TaskFactory.getParams());
        }

        public static void deliveryHeades(Map<String, Object> params) {
            ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
            if (requestAttributes != null) {
                HttpServletRequest request = requestAttributes.getRequest();
                TaskFactory.doReflectSetparam(params, request, CloudThreadPools.GLOBAL_TRACE_ID);
                TaskFactory.doReflectSetparam(params, request, CloudThreadPools.PARENT_TRACE_ID);
                TaskFactory.doReflectSetparam(params, request, CloudThreadPools.AUTHORIZATION_HEADER);
                TaskFactory.doReflectSetparam(params, request, CloudThreadPools.SHARDING_KEY);
                TaskFactory.doReflectSetparam(params, request, CloudThreadPools.TSF_TAGS);
            }
        }

        private static void doReflectSetparam(Map<String, Object> params, HttpServletRequest request, String tag) {
            Object value = params.get(tag);
            if (value != null) {
                TaskFactory.reflectSetparam(request, tag, (String)value);
            }
        }

        private static boolean reflectSetparam(HttpServletRequest request, String key, String value) {
            Class<?> requestClass = request.getClass();
            log.debug("request impl {}", (Object)requestClass.getName());
            try {
                Method methodRemoveHeader = requestClass.getMethod("removeHeader", String.class);
                methodRemoveHeader.invoke((Object)request, key);
                Method methodAddHeader = requestClass.getMethod("addHeader", String.class, Object.class);
                methodAddHeader.invoke((Object)request, key, value);
                return true;
            }
            catch (Exception e) {
                log.warn("{}", (Object)e.getMessage(), (Object)e);
                return false;
            }
        }
    }
}

