/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.dao.database;

import ins.framework.dao.database.DatabaseDao;
import ins.framework.dao.database.DatabaseFindDaoHibernateImpl;
import ins.framework.dao.database.util.InjectionCheckUtils;
import java.io.Serializable;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.springframework.orm.hibernate4.HibernateCallback;
import org.springframework.util.Assert;

public class DatabaseDaoHibernateImpl
extends DatabaseFindDaoHibernateImpl
implements DatabaseDao {
    @Override
    public Long getSequence(final String sequenceName) {
        Assert.hasText((String)sequenceName, (String)"sequenceName must have value.");
        InjectionCheckUtils.checkValidName(sequenceName);
        Long seq = (Long)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<Long>(){

            public Long doInHibernate(Session session) throws HibernateException {
                SQLQuery sqlQuery = session.createSQLQuery("select " + sequenceName + ".nextval from systables where tabid=1");
                List list = sqlQuery.list();
                return Long.valueOf(list.get(0).toString());
            }
        });
        return seq;
    }

    @Override
    public long getCount(String hql, Object ... values) {
        Assert.hasText((String)hql, (String)"getCount hql must have value.");
        InjectionCheckUtils.checkValidHql(hql);
        StringBuilder countQueryString = new StringBuilder(hql.length() + 20).append(" select count (*) ").append(DatabaseDaoHibernateImpl.removeSelect(DatabaseDaoHibernateImpl.removeOrders(hql)));
        List countList = this.getHibernateTemplate().find(countQueryString.toString(), values);
        return (Long)countList.get(0);
    }

    @Override
    public void clear() {
        this.getHibernateTemplate().clear();
    }

    @Override
    public void flush() {
        this.getHibernateTemplate().flush();
    }

    @Override
    public <T> T findByPK(Class<T> entityClass, Serializable id) {
        return (T)this.getHibernateTemplate().get(entityClass, id);
    }

    @Override
    public <T> List<T> findAll(Class<T> entityClass) {
        return this.getHibernateTemplate().loadAll(entityClass);
    }

    @Override
    public <T> Serializable save(Class<T> entityClass, Object obj) {
        return this.getHibernateTemplate().save(obj);
    }

    @Override
    public <T> void update(Class<T> entityClass, Object obj) {
        this.getHibernateTemplate().update(obj);
    }

    @Override
    public <T> void saveAll(Class<T> entityClass, List<T> list) {
        for (T object : list) {
            this.getHibernateTemplate().merge(object);
        }
    }

    @Override
    public <T> void deleteByObject(Class<T> entityClass, Object obj) {
        this.getHibernateTemplate().delete(obj);
    }

    @Override
    public <T> void deleteAll(Class<T> entityClass, List<T> entityList) {
        this.getHibernateTemplate().deleteAll(entityList);
    }

    @Override
    public <T> void deleteByPK(Class<T> entityClass, Serializable id) {
        T obj = this.findByPK(entityClass, id);
        if (obj != null) {
            this.deleteByObject(entityClass, obj);
        }
    }

    @Override
    public <T> void evictObject(Class<T> entityClass, Object obj) {
        this.getHibernateTemplate().evict(obj);
    }

    @Override
    public <T> boolean exists(Class<T> entityClass, Serializable id) {
        T entity = this.findByPK(entityClass, id);
        return entity != null;
    }
}

