/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.dao.database;

import ins.framework.dao.database.DatabaseFindDao;
import ins.framework.dao.database.support.Page;
import ins.framework.dao.database.support.QueryRule;
import ins.framework.dao.database.support.QueryRuleUtils;
import ins.framework.dao.database.util.InjectionCheckUtils;
import ins.framework.lang.Beans;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;
import org.hibernate.internal.CriteriaImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.orm.hibernate4.HibernateCallback;
import org.springframework.orm.hibernate4.support.HibernateDaoSupport;
import org.springframework.util.Assert;

public class DatabaseFindDaoHibernateImpl
extends HibernateDaoSupport
implements DatabaseFindDao {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatabaseFindDaoHibernateImpl.class);
    private static final String CACHEABLE_KEY = "CACHEABLE_KEY";
    private static final int DEFAULT_PAGE_SIZE = 10;
    private static final ThreadLocal<Map<String, Boolean>> cacheThreadLocal = new ThreadLocal();
    private static final Pattern ORDER_PATTERN = Pattern.compile("order\\s*by[\\w|\\W|\\s|\\S]*", 2);
    static Pattern hqlQueryCacheFlagPattern = Pattern.compile("[\\d\\D]+?\\W((?i)(count|avg|sum|max|min))\\s*\\([\\d\\D]+?");

    protected boolean isCacheable(Session session) {
        Boolean cacheable;
        String key = "CACHEABLE_KEY|" + DatabaseFindDaoHibernateImpl.class + "|" + System.identityHashCode(session);
        Map<String, Boolean> cacheMap = cacheThreadLocal.get();
        if (cacheMap == null) {
            cacheMap = new HashMap<String, Boolean>();
            cacheThreadLocal.set(cacheMap);
        }
        return (cacheable = cacheMap.get(key)) == null ? true : cacheable;
    }

    protected void setCacheable(Session session, boolean cacheable) {
        String key = "CACHEABLE_KEY|" + DatabaseFindDaoHibernateImpl.class + "|" + System.identityHashCode(session);
        Map<String, Boolean> cacheMap = cacheThreadLocal.get();
        if (cacheMap == null) {
            cacheMap = new HashMap<String, Boolean>();
            cacheThreadLocal.set(cacheMap);
        }
        cacheMap.put(key, cacheable);
    }

    protected void setCacheable(boolean cacheable) {
        this.setCacheable(this.getSessionFactory().getCurrentSession(), cacheable);
    }

    protected static String removeSelect(String hql) {
        Assert.hasText((String)hql);
        int beginPos = hql.toLowerCase(Locale.US).indexOf("from");
        Assert.isTrue((beginPos != -1 ? 1 : 0) != 0, (String)(" hql : " + hql + " must has a keyword 'from'"));
        return hql.substring(beginPos);
    }

    protected static String removeOrders(String hql) {
        Assert.hasText((String)hql);
        Matcher m = ORDER_PATTERN.matcher(hql);
        if (m.find()) {
            return hql.substring(0, m.start());
        }
        return hql;
    }

    protected static boolean isIncludeDistinct(String hql) {
        String hqlLowerCase = hql.toLowerCase(Locale.US);
        return (hqlLowerCase = hqlLowerCase.replace(" ", "")).startsWith("selectdistinct");
    }

    protected static String getDistinctCountHql(String hql) {
        String hqlSelect = hql.toLowerCase(Locale.US).split("from")[0];
        String hqlSelectDistinct = hqlSelect.split(",")[0];
        hqlSelectDistinct = hql.substring(0, hqlSelectDistinct.length());
        String coml = hqlSelectDistinct.split("distinct")[1];
        coml = coml.replace("(", " ");
        coml = coml.replace(")", " ");
        return "select count(distinct " + coml + ")";
    }

    protected static List<Order> getOrderFromQueryRule(QueryRule queryRule) {
        ArrayList<Order> orders = new ArrayList<Order>();
        for (QueryRule.Rule rule : queryRule.getRuleList()) {
            switch (rule.getType()) {
                case 101: {
                    if (!StringUtils.isNotEmpty((CharSequence)rule.getPropertyName())) break;
                    orders.add(Order.asc((String)rule.getPropertyName()));
                    break;
                }
                case 102: {
                    if (!StringUtils.isNotEmpty((CharSequence)rule.getPropertyName())) break;
                    orders.add(Order.desc((String)rule.getPropertyName()));
                    break;
                }
            }
        }
        return orders;
    }

    protected static String processQL(String ql, Object ... values) {
        String newQL = ql;
        int pos = 0;
        for (int i = 0; i < values.length; ++i) {
            if ((pos = newQL.indexOf(63, pos)) == -1) {
                throw new IllegalArgumentException("params and values must match.");
            }
            if (values[i] instanceof Collection) {
                newQL = newQL.substring(0, pos) + ":queryParam" + i + newQL.substring(pos + 1);
            }
            ++pos;
        }
        return newQL;
    }

    public long getCountByHql(String hql, Object ... values) {
        Assert.hasText((String)hql, (String)"hql must have value.");
        InjectionCheckUtils.checkValidHql(hql);
        String fnHql = DatabaseFindDaoHibernateImpl.processQL(hql, values);
        StringBuilder countQueryString = new StringBuilder(fnHql.length() + 20).append(" select count (*) ").append(DatabaseFindDaoHibernateImpl.removeSelect(DatabaseFindDaoHibernateImpl.removeOrders(fnHql)));
        List countList = this.getHibernateTemplate().find(countQueryString.toString(), values);
        return (Long)countList.get(0);
    }

    public long getCountBySql(String sql, Object ... values) {
        Assert.hasText((String)sql, (String)"sql must have value.");
        InjectionCheckUtils.checkValidSql(sql);
        String fnSql = DatabaseFindDaoHibernateImpl.processQL(sql, values);
        StringBuilder countQueryString = new StringBuilder(fnSql.length() + 60).append(" select count (*) from ( ").append(fnSql).append(") as DatabaseDao_Count");
        List countList = this.getHibernateTemplate().find(countQueryString.toString(), values);
        return (Long)countList.get(0);
    }

    public long getCount(final Class<?> entityClass, final QueryRule queryRule) {
        Long count = (Long)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<Long>(){

            public Long doInHibernate(Session session) throws HibernateException {
                Criteria criteria = session.createCriteria(entityClass);
                QueryRuleUtils.createCriteriaWithQueryRule(criteria, queryRule);
                CriteriaImpl impl = (CriteriaImpl)criteria;
                try {
                    Beans.forceSetProperty((Object)impl, (String)"orderEntries", new ArrayList());
                }
                catch (NoSuchFieldException e) {
                    LOGGER.debug("{}", (Throwable)e);
                }
                long totalCount = Long.valueOf("" + criteria.setProjection(Projections.rowCount()).uniqueResult());
                return totalCount;
            }
        });
        return count;
    }

    protected Query createQuery(String fnHql, Session session) {
        Query query = session.createQuery(fnHql);
        if (!hqlQueryCacheFlagPattern.matcher(fnHql).matches()) {
            query.setCacheable(this.isCacheable(session));
        } else {
            query.setCacheable(false);
            session.flush();
        }
        return query;
    }

    @Override
    public <T> List<T> findRangeByHql(Class<T> entityClass, String hql, final int start, final int length, final Object ... values) {
        Assert.hasText((String)hql, (String)"hql must have value.");
        InjectionCheckUtils.checkValidHql(hql);
        final String fnHql = DatabaseFindDaoHibernateImpl.processQL(hql, values);
        List list = (List)this.getHibernateTemplate().execute(new HibernateCallback<List<T>>(){

            public List<T> doInHibernate(Session session) throws HibernateException {
                Query query = DatabaseFindDaoHibernateImpl.this.createQuery(fnHql, session);
                for (int i = 0; i < values.length; ++i) {
                    if (values[i] instanceof Collection) {
                        query.setParameterList("queryParam" + i, (Collection)values[i]);
                        continue;
                    }
                    query.setParameter(i, values[i]);
                }
                query.setFirstResult(start);
                query.setMaxResults(length);
                query.setCacheable(true);
                return query.list();
            }
        });
        return list;
    }

    @Override
    public <T> List<T> findAllByHql(Class<T> entityClass, String hql, Object ... values) {
        return this.findRangeByHql(entityClass, hql, 0, Integer.MAX_VALUE, values);
    }

    @Override
    public <T> List<T> findTopByHql(Class<T> entityClass, String hql, int top, Object ... values) {
        return this.findRangeByHql(entityClass, hql, 0, top, values);
    }

    @Override
    public <T> T findUniqueByHql(Class<T> entityClass, String hql, Object ... values) {
        List<T> list = this.findRangeByHql(entityClass, hql, 0, 2, values);
        if (list.isEmpty()) {
            return null;
        }
        if (list.size() > 1) {
            throw new IllegalStateException("findUnique return multi records.");
        }
        return list.get(0);
    }

    @Override
    public <T> Page<T> findPageByHql(Class<T> entityClass, String hql, int pageNo, int pageSize, Object ... values) {
        int startIndex;
        Assert.hasText((String)hql);
        InjectionCheckUtils.checkValidHql(hql);
        if (pageNo <= 0) {
            pageNo = 1;
        }
        if (pageSize <= 0) {
            pageSize = 10;
        }
        if ((startIndex = Page.getStartOfPage(pageNo, pageSize)) < 0) {
            return new Page();
        }
        long totalCount = this.getCountByHql(hql, values);
        List<T> list = this.findRangeByHql(entityClass, hql, startIndex, pageSize, values);
        return new Page<T>(startIndex, totalCount, pageSize, list);
    }

    @Override
    public List<Object[]> findRangeByHql(String hql, int start, int length, Object ... values) {
        return this.findRangeByHql(Object[].class, hql, start, length, values);
    }

    @Override
    public List<Object[]> findAllByHql(String hql, Object ... values) {
        return this.findAllByHql(Object[].class, hql, values);
    }

    @Override
    public List<Object[]> findTopByHql(String hql, int top, Object ... values) {
        return this.findTopByHql(Object[].class, hql, top, values);
    }

    @Override
    public Object[] findUniqueByHql(String hql, Object ... values) {
        return this.findUniqueByHql(Object[].class, hql, values);
    }

    @Override
    public Page<Object[]> findPageByHql(String hql, int pageNo, int pageSize, Object ... values) {
        return this.findPageByHql(Object[].class, hql, pageNo, pageSize, values);
    }

    @Override
    public <T> List<T> findRange(final Class<T> entityClass, final QueryRule queryRule, final int start, final int length) {
        List list = (List)this.getHibernateTemplate().execute(new HibernateCallback<List<T>>(){

            public List<T> doInHibernate(Session session) throws HibernateException {
                Criteria criteria = session.createCriteria(entityClass);
                QueryRuleUtils.createCriteriaWithQueryRule(criteria, queryRule);
                List<Order> orders = DatabaseFindDaoHibernateImpl.getOrderFromQueryRule(queryRule);
                for (Order o : orders) {
                    criteria.addOrder(o);
                }
                criteria.setCacheable(DatabaseFindDaoHibernateImpl.this.isCacheable(session));
                criteria.setFirstResult(start);
                criteria.setMaxResults(length);
                return criteria.list();
            }
        });
        return list;
    }

    @Override
    public <T> List<T> findAll(Class<T> entityClass, QueryRule queryRule) {
        return this.findRange(entityClass, queryRule, 0, Integer.MAX_VALUE);
    }

    @Override
    public <T> List<T> findTop(Class<T> entityClass, QueryRule queryRule, int top) {
        return this.findRange(entityClass, queryRule, 0, top);
    }

    @Override
    public <T> T findUnique(Class<T> entityClass, QueryRule queryRule) {
        List<T> list = this.findRange(entityClass, queryRule, 0, 2);
        if (list.isEmpty()) {
            return null;
        }
        if (list.size() > 1) {
            throw new IllegalStateException("findUnique return multi records.");
        }
        return list.get(0);
    }

    @Override
    public <T> Page<T> findPage(Class<T> entityClass, QueryRule queryRule, int pageNo, int pageSize) {
        if (pageNo <= 0) {
            pageNo = 1;
        }
        if (pageSize <= 0) {
            pageSize = 10;
        }
        int startIndex = Page.getStartOfPage(pageNo, pageSize);
        long totalCount = this.getCount(entityClass, queryRule);
        List<T> list = this.findRange(entityClass, queryRule, startIndex, pageSize);
        return new Page<T>(startIndex, totalCount, pageSize, list);
    }

    @Override
    public <T> List<T> findRangeBySql(Class<T> entityClass, String sql, final int start, final int length, final Object ... values) {
        Assert.hasText((String)sql, (String)"sql must have value.");
        InjectionCheckUtils.checkValidSql(sql);
        final String fnSql = DatabaseFindDaoHibernateImpl.processQL(sql, values);
        List list = (List)this.getHibernateTemplate().execute(new HibernateCallback<List<T>>(){

            public List<T> doInHibernate(Session session) throws HibernateException {
                SQLQuery query = session.createSQLQuery(fnSql);
                if (values != null) {
                    for (int i = 0; i < values.length; ++i) {
                        query.setParameter(i, values[i]);
                    }
                }
                query.setFirstResult(start);
                query.setMaxResults(length);
                return query.list();
            }
        });
        return list;
    }

    @Override
    public <T> List<T> findAllBySql(Class<T> entityClass, String sql, Object ... values) {
        return this.findAllBySql(entityClass, sql, 0, Integer.MAX_VALUE, values);
    }

    @Override
    public <T> List<T> findTopBySql(Class<T> entityClass, String sql, int top, Object ... values) {
        return this.findRangeBySql(entityClass, sql, 0, top, values);
    }

    @Override
    public <T> T findUniqueBySql(Class<T> entityClass, String sql, Object ... values) {
        List<T> list = this.findRangeBySql(entityClass, sql, 0, 2, values);
        if (list.isEmpty()) {
            return null;
        }
        if (list.size() > 1) {
            throw new IllegalStateException("findUnique return multi records.");
        }
        return list.get(0);
    }

    @Override
    public <T> Page<T> findPageBySql(Class<T> entityClass, String sql, int pageNo, int pageSize, Object ... values) {
        int startIndex;
        Assert.hasText((String)sql);
        InjectionCheckUtils.checkValidSql(sql);
        if (pageNo <= 0) {
            pageNo = 1;
        }
        if (pageSize <= 0) {
            pageSize = 10;
        }
        if ((startIndex = Page.getStartOfPage(pageNo, pageSize)) < 0) {
            return new Page();
        }
        long totalCount = this.getCountBySql(sql, values);
        List<T> list = this.findRangeBySql(entityClass, sql, startIndex, pageSize, values);
        return new Page<T>(startIndex, totalCount, pageSize, list);
    }

    @Override
    public List<Object[]> findRangeBySql(String sql, int start, int length, Object ... values) {
        return this.findRangeBySql(Object[].class, sql, start, length, values);
    }

    @Override
    public List<Object[]> findAllBySql(String sql, Object ... values) {
        return this.findAllBySql(Object[].class, sql, values);
    }

    @Override
    public List<Object[]> findTopBySql(String sql, int top, Object ... values) {
        return this.findTopBySql(Object[].class, sql, top, values);
    }

    @Override
    public Object[] findUniqueBySql(String sql, Object ... values) {
        return this.findUniqueBySql(Object[].class, sql, values);
    }

    @Override
    public Page<Object[]> findPageBySql(String sql, int pageNo, int pageSize, Object ... values) {
        return this.findPageBySql(Object[].class, sql, pageNo, pageSize, values);
    }

    @Override
    public <T> T findUniqueByKV(Class<T> entityClass, String propertyName, Object value) {
        QueryRule queryRule = QueryRule.getInstance();
        queryRule.addEqual(propertyName, value);
        return this.findUnique(entityClass, queryRule);
    }

    @Override
    public <T> T findUniqueByMap(Class<T> entityClass, Map<String, Object> properties) {
        QueryRule queryRule = QueryRule.getInstance();
        for (String key : properties.keySet()) {
            queryRule.addEqual(key, properties.get(key));
        }
        return this.findUnique(entityClass, queryRule);
    }

    @Override
    public List findLazyByHql(String hql, Integer pageNo, Integer pageSize, Object ... values) {
        int startIndex;
        Assert.hasText((String)hql);
        InjectionCheckUtils.checkValidHql(hql);
        if (pageNo <= 0) {
            pageNo = 1;
        }
        if (pageSize <= 0) {
            pageSize = 10;
        }
        if ((startIndex = Page.getStartOfPage(pageNo, pageSize)) < 0) {
            return new ArrayList();
        }
        List<Object[]> list = this.findRangeByHql(hql, startIndex, (int)pageSize, values);
        return list;
    }

    @Override
    public List findLazyBySql(String sql, Integer pageNo, Integer pageSize, Object ... values) {
        int startIndex;
        Assert.hasText((String)sql);
        InjectionCheckUtils.checkValidSql(sql);
        if (pageNo <= 0) {
            pageNo = 1;
        }
        if (pageSize <= 0) {
            pageSize = 10;
        }
        if ((startIndex = Page.getStartOfPage(pageNo, pageSize)) < 0) {
            return new ArrayList();
        }
        List<Object[]> list = this.findRangeBySql(sql, startIndex, (int)pageSize, values);
        return list;
    }
}

