/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.dao.database.support;

import ins.framework.dao.database.DatabaseDao;
import java.util.AbstractList;
import java.util.List;

public class LazyPage<T>
extends AbstractList {
    public static final int DEFAULT_SIZE = 25;
    DatabaseDao dao;
    int pageNo;
    int pageSize;
    List cacheList;
    String hql;
    int cachePageNo;
    String[] args;
    String type;

    public LazyPage(DatabaseDao dao, String hql, String type, String ... args) {
        this(dao, hql, type, 1, 25, args);
    }

    public LazyPage(DatabaseDao dao, String hql, String type, int pageSize, String ... args) {
        this(dao, hql, type, 1, pageSize, args);
    }

    public LazyPage(DatabaseDao dao, String hql, String type, int pageNo, int pageSize, String ... args) {
        this.dao = dao;
        this.hql = hql;
        this.setPageNo(pageNo);
        this.setPageSize(pageSize);
        this.args = args;
        this.type = type;
    }

    public int getPageNo() {
        return this.pageNo;
    }

    public LazyPage setPageNo(int pageNo) {
        this.pageNo = pageNo = pageNo < 1 ? 1 : pageNo;
        return this;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        if (pageSize < 1) {
            throw new IllegalArgumentException("The pageSize can't be less than one");
        }
        this.pageSize = pageSize;
    }

    @Override
    public Object get(int index) {
        this.cachePageNo = index / 25 + 1;
        if (this.cachePageNo != this.pageNo) {
            this.pageNo = this.cachePageNo;
            this.cacheList = null;
        }
        if (this.cacheList == null) {
            this.cacheList = "sql".equals(this.type) ? this.dao.findLazyBySql(this.hql, this.pageNo, this.pageSize, this.args) : this.dao.findLazyByHql(this.hql, this.pageNo, this.pageSize, this.args);
        }
        return this.cacheList.get(index %= 25);
    }

    @Override
    public int size() {
        if (this.cacheList == null) {
            return 0;
        }
        return this.cacheList.size();
    }

    public int getTotalCount() {
        return Integer.parseInt(this.dao.getCount(this.hql, this.args) + "");
    }
}

