/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.dao.database.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InjectionCheckUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(InjectionCheckUtils.class);

    private InjectionCheckUtils() {
    }

    public static boolean isValidSql(String sql) {
        String reg = "^[([a-zA-Z])([0-9])(\\s)([><=*!_?:.(),-/])(\\+)]*$";
        boolean valid = sql.matches(reg);
        if (!valid) {
            LOGGER.warn("Invalid sql [{}]", (Object)sql);
        }
        return valid;
    }

    public static boolean isValidHql(String hql) {
        String reg = "^[([a-zA-Z])([0-9])(\\s)([><=*!_?:.(),-/])(\\+)]*$";
        boolean valid = hql.matches(reg);
        if (!valid) {
            LOGGER.warn("Invalid hql [{}]", (Object)hql);
        }
        return valid;
    }

    public static boolean isValidName(String name) {
        String reg = "^[([a-zA-Z])([0-9])([_])]*$";
        return name.matches(reg);
    }

    public static void checkValidName(String name) {
        if (!InjectionCheckUtils.isValidName(name)) {
            throw new IllegalArgumentException("Invalid name.");
        }
    }

    public static void checkValidSql(String sql) {
        if (!InjectionCheckUtils.isValidHql(sql)) {
            throw new IllegalArgumentException("Invalid sql.");
        }
    }

    public static void checkValidHql(String hql) {
        if (!InjectionCheckUtils.isValidHql(hql)) {
            throw new IllegalArgumentException("Invalid hql.");
        }
    }
}

