/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.lang;

import ins.framework.lang.Constants;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.apache.commons.beanutils.ConstructorUtils;
import org.apache.commons.beanutils.MethodUtils;

public class Proxys {
    private static final Class<?>[] EMPTY_TYPES = new Class[0];

    private Proxys() {
    }

    public static <T> T newProxyInstance(final InvocationHandler invocationHandler, Class<T> mainType, Class<?>[] otherTypes, Object ... arguments) {
        ArrayList interfaceTypes = new ArrayList();
        Class<Object> superClass = null;
        if (!mainType.isInterface()) {
            superClass = mainType;
        } else {
            interfaceTypes.add(mainType);
        }
        if (otherTypes != null) {
            for (Class<?> otherType : otherTypes) {
                if (!otherType.isInterface()) {
                    if (superClass != null) {
                        throw new IllegalArgumentException(String.format("Should not be more than one super class:%s and %s", superClass, otherType));
                    }
                    superClass = otherType;
                    continue;
                }
                interfaceTypes.add(otherType);
            }
        }
        if (superClass == null) {
            return (T)Proxy.newProxyInstance(Proxys.getClassLoader(), interfaceTypes.toArray(new Class[0]), new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    return Proxys.invokeMethod(invocationHandler, proxy, method, args);
                }
            });
        }
        Enhancer en = new Enhancer();
        en.setUseCache(true);
        en.setUseFactory(false);
        en.setSuperclass(superClass);
        en.setInterfaces(interfaceTypes.toArray(new Class[0]));
        en.setCallback((Callback)new MethodInterceptor(){

            public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
                return Proxys.invokeMethod(invocationHandler, obj, method, args);
            }
        });
        if (arguments == null || arguments.length == 0) {
            return (T)en.create();
        }
        int argumentLength = arguments.length;
        Class[] parameterTypes = new Class[argumentLength];
        for (int i = 0; i < argumentLength; ++i) {
            parameterTypes[i] = arguments[i] == null ? null : arguments[i].getClass();
        }
        try {
            return (T)en.create(parameterTypes, arguments);
        }
        catch (Throwable e) {
            Constructor<T> constructor = Proxys.getMatchingAccessibleConstructor(superClass, parameterTypes);
            if (constructor == null) {
                throw new IllegalArgumentException(String.format("Could not found a constructor of type:%s for arguments types:%s", superClass.getCanonicalName(), Proxys.argumentTypesToString(parameterTypes)));
            }
            return (T)en.create((Class[])constructor.getParameterTypes(), arguments);
        }
    }

    private static ClassLoader getClassLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return classLoader == null ? Proxys.class.getClassLoader() : classLoader;
    }

    private static <T> Constructor<T> getMatchingAccessibleConstructor(Class<T> clazz, Class<?>[] parameterTypes) {
        try {
            Constructor<T> ctor = clazz.getConstructor(parameterTypes);
            try {
                ctor.setAccessible(true);
            }
            catch (SecurityException se) {
                // empty catch block
            }
            return ctor;
        }
        catch (NoSuchMethodException e) {
            int paramSize = parameterTypes.length;
            Constructor<?>[] ctors = clazz.getConstructors();
            int size = ctors.length;
            for (int i = 0; i < size; ++i) {
                Constructor ctor;
                Class<?>[] ctorParams = ctors[i].getParameterTypes();
                int ctorParamSize = ctorParams.length;
                if (ctorParamSize != paramSize) continue;
                boolean match = true;
                for (int n = 0; n < ctorParamSize; ++n) {
                    if (MethodUtils.isAssignmentCompatible(ctorParams[n], parameterTypes[n])) continue;
                    match = false;
                    break;
                }
                if (!match || (ctor = ConstructorUtils.getAccessibleConstructor(ctors[i])) == null) continue;
                try {
                    ctor.setAccessible(true);
                }
                catch (SecurityException se) {
                    // empty catch block
                }
                Constructor typedCtor = ctor;
                return typedCtor;
            }
            return null;
        }
    }

    private static String argumentTypesToString(Class<?>[] argTypes) {
        StringBuilder buf = new StringBuilder();
        buf.append("(");
        if (argTypes != null) {
            for (int i = 0; i < argTypes.length; ++i) {
                Class<?> c;
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append((c = argTypes[i]) == null ? "null" : c.getName());
            }
        }
        buf.append(")");
        return buf.toString();
    }

    public static <T> T newProxyInstance(InvocationHandler invocationHandler, Class<T> mainType, Class<?> ... otherTypes) {
        return Proxys.newProxyInstance(invocationHandler, mainType, otherTypes, Constants.EMPTY_ARRAY);
    }

    public static <T> T newProxyInstance(InvocationHandler invocationHandler, Class<T> mainType, Object ... arguments) {
        return Proxys.newProxyInstance(invocationHandler, mainType, EMPTY_TYPES, arguments);
    }

    public static <T> T newProxyInstance(InvocationHandler invocationHandler, Class<T> mainType) {
        return Proxys.newProxyInstance(invocationHandler, mainType, EMPTY_TYPES);
    }

    private static Object invokeMethod(InvocationHandler invocationHandler, Object proxy, Method method, Object[] args) throws Throwable {
        return invocationHandler.invoke(proxy, method, args);
    }
}

