/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.lang;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class Beans {
    private static final Logger logger = LoggerFactory.getLogger(Beans.class);

    private Beans() {
    }

    public static Field getDeclaredField(Object object, String propertyName) throws NoSuchFieldException {
        Assert.notNull((Object)object, (String)"object must not null");
        Assert.hasText((String)propertyName, (String)"propertyName must have value.");
        return Beans.getDeclaredField(object.getClass(), propertyName);
    }

    public static Field getDeclaredField(Class<?> clazz, String propertyName) throws NoSuchFieldException {
        Assert.notNull(clazz, (String)"clazz must not null");
        Assert.hasText((String)propertyName, (String)"propertyName must have value.");
        for (Class<?> superClass = clazz; superClass != Object.class; superClass = superClass.getSuperclass()) {
            try {
                return superClass.getDeclaredField(propertyName);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                continue;
            }
        }
        throw new NoSuchFieldException("No such field: " + clazz.getName() + '.' + propertyName);
    }

    public static Object forceGetProperty(Object object, String propertyName) throws NoSuchFieldException {
        Assert.notNull((Object)object, (String)"object must not null");
        Assert.hasText((String)propertyName, (String)"propertyName must have value.");
        Field field = Beans.getDeclaredField(object, propertyName);
        boolean accessible = field.isAccessible();
        field.setAccessible(true);
        Object result = null;
        try {
            result = field.get(object);
        }
        catch (IllegalAccessException e) {
            logger.info("error wont' happen");
        }
        field.setAccessible(accessible);
        return result;
    }

    public static void forceSetProperty(Object object, String propertyName, Object newValue) throws NoSuchFieldException {
        Assert.notNull((Object)object, (String)"object must not null");
        Assert.hasText((String)propertyName, (String)"propertyName must have value.");
        Field field = Beans.getDeclaredField(object, propertyName);
        boolean accessible = field.isAccessible();
        field.setAccessible(true);
        try {
            field.set(object, newValue);
        }
        catch (IllegalAccessException e) {
            logger.info("Error won't happen");
        }
        field.setAccessible(accessible);
    }

    public static Object invokePrivateMethod(Object object, String methodName, Object ... params) throws NoSuchMethodException {
        Assert.notNull((Object)object, (String)"object must not null");
        Assert.hasText((String)methodName, (String)"methodName must have value.");
        Class[] types = new Class[params.length];
        for (int i = 0; i < params.length; ++i) {
            types[i] = params[i].getClass();
        }
        Class<?> clazz = object.getClass();
        AccessibleObject method = null;
        for (Class<?> superClass = clazz; superClass != Object.class; superClass = superClass.getSuperclass()) {
            try {
                method = superClass.getDeclaredMethod(methodName, types);
                break;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                continue;
            }
        }
        if (method == null) {
            throw new NoSuchMethodException("No Such Method:" + clazz.getSimpleName() + methodName);
        }
        boolean accessible = method.isAccessible();
        ((Method)method).setAccessible(true);
        Object result = null;
        try {
            result = ((Method)method).invoke(object, params);
        }
        catch (Exception e) {
            ReflectionUtils.handleReflectionException((Exception)e);
        }
        ((Method)method).setAccessible(accessible);
        return result;
    }

    public static List<Field> getFieldsByType(Object object, Class<?> type) {
        Field[] fields;
        ArrayList<Field> list = new ArrayList<Field>();
        for (Field field : fields = object.getClass().getDeclaredFields()) {
            if (!field.getType().isAssignableFrom(type)) continue;
            list.add(field);
        }
        return list;
    }

    public static Class<?> getPropertyType(Class<?> type, String name) throws NoSuchFieldException {
        return Beans.getDeclaredField(type, name).getType();
    }

    public static String getGetterName(Class<?> type, String fieldName) {
        Assert.notNull(type, (String)"Type required");
        Assert.hasText((String)fieldName, (String)"FieldName required");
        if (type.isAssignableFrom(Boolean.class)) {
            return "is" + StringUtils.capitalize((String)fieldName);
        }
        return "get" + StringUtils.capitalize((String)fieldName);
    }

    public static Method getGetterMethod(Class<?> type, String fieldName) {
        try {
            return type.getMethod(Beans.getGetterName(type, fieldName), new Class[0]);
        }
        catch (NoSuchMethodException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static Object invoke(String className, String methodName, Class<?>[] argsClass, Object[] args) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Class<?> cl = Class.forName(className);
        Method method = cl.getMethod(methodName, argsClass);
        return method.invoke(cl.newInstance(), args);
    }

    public static Object invoke(Object oldObject, String methodName, Class<?>[] argsClass, Object[] args) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Class<?> cl = oldObject.getClass();
        Method method = cl.getMethod(methodName, argsClass);
        return method.invoke(oldObject, args);
    }

    public static String[] getFieldsName(Class<?> cl) {
        Field[] fields = cl.getDeclaredFields();
        String[] fieldNames = new String[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            fieldNames[i] = fields[i].getName();
        }
        return fieldNames;
    }

    public static List<String> getAllFieldName(Class<?> cl) {
        ArrayList<String> list = new ArrayList<String>();
        Field[] fields = cl.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            if (field.getName().equals("serialVersionUID")) continue;
            list.add(field.getName());
        }
        while ((cl = cl.getSuperclass()) != Object.class) {
            list.addAll(Beans.getAllFieldName(cl));
        }
        return list;
    }

    public static List<Method> getSetter(Class<?> cl) {
        ArrayList<Method> list = new ArrayList<Method>();
        Method[] methods = cl.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            String methodName = method.getName();
            if (!methodName.startsWith("set")) continue;
            list.add(method);
        }
        while ((cl = cl.getSuperclass()) != Object.class) {
            list.addAll(Beans.getSetter(cl));
        }
        return list;
    }

    public static List<Method> getGetter(Class<?> cl) {
        ArrayList<Method> list = new ArrayList<Method>();
        Method[] methods = cl.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            String methodName = method.getName();
            if (!methodName.startsWith("get") && !methodName.startsWith("is")) continue;
            list.add(method);
        }
        while ((cl = cl.getSuperclass()) != Object.class) {
            list.addAll(Beans.getGetter(cl));
        }
        return list;
    }

    public static String getClassNameWithoutPackage(Class<?> cl) {
        String className = cl.getName();
        int pos = className.lastIndexOf(46) + 1;
        if (pos == -1) {
            pos = 0;
        }
        return className.substring(pos);
    }

    public static String beanToString(Object obj) {
        return ToStringBuilder.reflectionToString((Object)obj);
    }
}

