/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.lang;

import ins.framework.lang.ClassFilter;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class Classes {
    private static final String PATH_DELIMITER_JAR = "!/";
    private static final String PATH_DELIMITER_CLASSES = "classes/";
    private static final String DEFAULT_RESOURCE_PATTERN = "**/*.class";
    private static PathMatchingResourcePatternResolver pathMatchingResourcePatternResolver = new PathMatchingResourcePatternResolver();

    private Classes() {
    }

    public static Set<Class<?>> scanPackage(String basePackage, ClassFilter classFilter) {
        String packageSearchPath = "classpath*:" + basePackage.replace('.', '/') + "/" + DEFAULT_RESOURCE_PATTERN;
        try {
            Resource[] resources = pathMatchingResourcePatternResolver.getResources(packageSearchPath);
            LinkedHashSet classes = new LinkedHashSet();
            for (Resource resource : resources) {
                String path = resource.getURL().getPath();
                int p = path.lastIndexOf(PATH_DELIMITER_CLASSES);
                if (p != -1) {
                    p += PATH_DELIMITER_CLASSES.length();
                } else {
                    p = path.lastIndexOf(PATH_DELIMITER_JAR);
                    if (p != -1) {
                        p += PATH_DELIMITER_JAR.length();
                    }
                }
                if (p == -1) continue;
                String name = path.substring(p, path.lastIndexOf(".")).replace('/', '.');
                try {
                    Class<?> type = Class.forName(name, false, Classes.class.getClassLoader());
                    if (type == null || !classFilter.accept(type)) continue;
                    classes.add(type);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return classes;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e.getCause());
        }
    }
}

