/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.lang;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;

public class Envs {
    private static String serverIp = null;
    private static final String UNKNOWN = "unknown";
    private static final String LOCALHOST = "127.0.0.1";

    private Envs() {
    }

    public static String getClientIp(HttpServletRequest request) {
        String[] ss;
        String ip = request.getHeader("x-forwarded-for");
        if (StringUtils.isEmpty((CharSequence)ip) || UNKNOWN.equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (StringUtils.isEmpty((CharSequence)ip) || UNKNOWN.equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (StringUtils.isEmpty((CharSequence)ip) || UNKNOWN.equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        for (String s : ss = ip.split(",")) {
            if (UNKNOWN.equalsIgnoreCase(s)) continue;
            ip = s;
            break;
        }
        return ip;
    }

    public static String getWebClassesPath() {
        String path = new File(Thread.currentThread().getContextClassLoader().getResource("").getPath()).getPath();
        path = path.replace("%20", " ");
        return path;
    }

    public static String getServerIp() {
        return serverIp;
    }

    private static String getInnerServerIp() {
        String ip;
        block7: {
            String osName = System.getProperty("os.name").toLowerCase();
            ip = null;
            try {
                if (osName.startsWith("linux")) {
                    ip = Envs.getLocalIp("/sbin/ip addr", "inet ", "", "/");
                    break block7;
                }
                if (osName.startsWith("window")) {
                    ip = Envs.getLocalIp("ipconfig /all", "IP Address", ": ", "(");
                    if (ip == null) {
                        ip = Envs.getLocalIp("ipconfig /all", "IPv4 \u5730\u5740", ":", "(");
                    }
                    break block7;
                }
                if (osName.startsWith("aix")) {
                    ip = Envs.getLocalIp("ifconfig -a", "inet ", "", "netmask");
                    break block7;
                }
                throw new IllegalStateException("Not support OS:" + osName);
            }
            catch (Exception e) {
                throw new IllegalStateException(e.toString(), e);
            }
        }
        if (ip == null) {
            ip = LOCALHOST;
        }
        return ip;
    }

    private static String getLocalIp(String cmd, String indLine, String indStart, String indEnd) throws IOException {
        String s;
        Runtime rt = Runtime.getRuntime();
        Process process = rt.exec(cmd);
        BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));
        while ((s = in.readLine()) != null) {
            if (!(s = s.trim()).startsWith(indLine)) continue;
            s = s.substring(indLine.length()).trim();
            int pos = s.indexOf(indStart);
            String ip = s.substring(indStart.length() + pos).trim();
            pos = ip.indexOf(indEnd);
            if (pos > -1) {
                ip = ip.substring(0, pos);
            }
            if (ip.startsWith("127.")) continue;
            return ip;
        }
        return null;
    }

    static {
        try {
            serverIp = Envs.getInnerServerIp();
        }
        catch (Exception e) {
            serverIp = LOCALHOST;
        }
    }
}

