/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.lang;

import ins.framework.lang.ClassFilter;
import java.util.LinkedHashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public final class Classes {
    private static final Logger log = LoggerFactory.getLogger(Classes.class);
    private static final String PATH_DELIMITER_JAR = "!/";
    private static final String PATH_DELIMITER_CLASSES = "classes/";
    private static final String DEFAULT_RESOURCE_PATTERN = "**/*.class";
    private static PathMatchingResourcePatternResolver pathMatchingResourcePatternResolver = new PathMatchingResourcePatternResolver();

    private Classes() {
    }

    public static Set<Class<?>> scanPackage(String basePackage, ClassFilter classFilter) {
        String packageSearchPath = "classpath*:" + basePackage.replace('.', '/') + "/" + DEFAULT_RESOURCE_PATTERN;
        LinkedHashSet classes = new LinkedHashSet();
        try {
            Resource[] resources;
            for (Resource resource : resources = pathMatchingResourcePatternResolver.getResources(packageSearchPath)) {
                String path = resource.getURL().getPath();
                int p = path.lastIndexOf(PATH_DELIMITER_CLASSES);
                if (p != -1) {
                    p += PATH_DELIMITER_CLASSES.length();
                } else {
                    p = path.lastIndexOf(PATH_DELIMITER_JAR);
                    if (p != -1) {
                        p += PATH_DELIMITER_JAR.length();
                    }
                }
                if (p == -1) continue;
                String name = path.substring(p, path.lastIndexOf(46)).replace('/', '.');
                try {
                    Class<?> type = Class.forName(name, false, Classes.class.getClassLoader());
                    if (type == null || !classFilter.accept(type)) continue;
                    classes.add(type);
                }
                catch (Exception e) {
                    log.warn("{}", (Object)e.getMessage(), (Object)e);
                }
            }
        }
        catch (Exception e) {
            log.warn("{}", (Object)e.getMessage(), (Object)e);
            throw new IllegalArgumentException(e.getMessage(), e.getCause());
        }
        return classes;
    }
}

