/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.lang;

import java.math.BigDecimal;

public final class Datas {
    private static final String[] TRUE_ARRAY = new String[]{"y", "yes", "true", "t", "\u662f", "1"};
    private static final String[] FALSE_ARRAY = new String[]{"n", "no", "false", "f", "\u5426", "0"};

    private Datas() {
    }

    public static String zeroToEmpty(int value) {
        String result = String.valueOf(value);
        if (value == 0) {
            result = "";
        }
        return result;
    }

    public static String nullToEmpty(String str) {
        String result = str;
        if (str == null) {
            result = "";
        }
        return result;
    }

    public static String emptyToNull(String str) {
        if (str == null || str.trim().length() == 0) {
            return null;
        }
        return str;
    }

    public static String dbNullToEmpty(String str) {
        if (str == null || "null".equalsIgnoreCase(str)) {
            return "";
        }
        return str;
    }

    public static String nullToZero(String str) {
        if (str == null || str.trim().length() == 0) {
            return "0";
        }
        return str;
    }

    public static String getBooleanDescribe(String str) {
        int i;
        if (str == null) {
            throw new IllegalArgumentException("argument is null");
        }
        String retValue = null;
        if ("".equals(str.trim())) {
            retValue = "";
        }
        for (i = 0; i < TRUE_ARRAY.length; ++i) {
            if (!str.equalsIgnoreCase(TRUE_ARRAY[i])) continue;
            retValue = "\u662f";
            break;
        }
        for (i = 0; i < FALSE_ARRAY.length; ++i) {
            if (!str.equalsIgnoreCase(FALSE_ARRAY[i])) continue;
            retValue = "\u5426";
            break;
        }
        if (retValue == null) {
            throw new IllegalArgumentException("argument not in ('y','n','yes','no','true','false','t','f','\u662f','\u5426','1','0','')");
        }
        return retValue;
    }

    public static boolean getBoolean(String str) {
        int i;
        if (str == null) {
            throw new IllegalArgumentException("argument is null");
        }
        for (i = 0; i < TRUE_ARRAY.length; ++i) {
            if (!str.equalsIgnoreCase(TRUE_ARRAY[i])) continue;
            return true;
        }
        for (i = 0; i < FALSE_ARRAY.length; ++i) {
            if (!str.equalsIgnoreCase(FALSE_ARRAY[i])) continue;
            return false;
        }
        if ("".equals(str.trim())) {
            return false;
        }
        throw new IllegalArgumentException("argument not in ('y','n','yes','no','true','false','t','f','\u662f','\u5426','1','0','')");
    }

    public static String getBooleanDescribe(boolean boolValue) {
        return Datas.getBooleanDescribe(String.valueOf(boolValue));
    }

    public static int compareByValue(String str1, String str2) {
        return new BigDecimal(str1).compareTo(new BigDecimal(str2));
    }
}

