/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.lang;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.IOUtils;

public final class Gzips {
    private Gzips() {
    }

    public static byte[] gzip(byte[] in) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(byteArrayOutputStream);
             GZIPOutputStream gzipOutputStream = new GZIPOutputStream(bufferedOutputStream);){
            gzipOutputStream.write(in);
            gzipOutputStream.finish();
            gzipOutputStream.flush();
            bufferedOutputStream.flush();
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] ungzip(byte[] in) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(in);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(byteArrayInputStream);
             GZIPInputStream gzipInputStream = new GZIPInputStream(bufferedInputStream);
             BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(byteArrayOutputStream);){
            IOUtils.copy((InputStream)gzipInputStream, (OutputStream)bufferedOutputStream);
            bufferedOutputStream.flush();
            byteArrayOutputStream.flush();
        }
        return byteArrayOutputStream.toByteArray();
    }
}

