/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.lang;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.crypto.hash.DefaultHashService;
import org.apache.shiro.crypto.hash.HashRequest;
import org.apache.shiro.util.ByteSource;
import org.springframework.util.Assert;

public class Passwords {
    private Passwords() {
    }

    public static String digestEncodedPassword(String encodedPassword, Map<String, Object> values) {
        Assert.notNull((Object)encodedPassword, (String)"Password must have value.");
        DefaultHashService hashService = new DefaultHashService();
        String staticSalt = (String)values.getOrDefault("staticSalt", "");
        if (StringUtils.isNotBlank((CharSequence)staticSalt)) {
            hashService.setPrivateSalt(ByteSource.Util.bytes((String)staticSalt));
        }
        if (!values.containsKey("algorithmName")) {
            throw new IllegalArgumentException("Specified algorithmName name does not exist in the results");
        }
        hashService.setHashAlgorithmName((String)values.getOrDefault("algorithmName", ""));
        Long numOfIterations = 0L;
        if (values.containsKey("numIterations")) {
            String longAsStr = values.getOrDefault("numIterations", "0").toString();
            numOfIterations = Long.valueOf(longAsStr);
        }
        hashService.setHashIterations(numOfIterations.intValue());
        if (!values.containsKey("salt")) {
            throw new IllegalArgumentException("Specified field name for salt does not exist in the results");
        }
        String dynaSalt = values.getOrDefault("salt", "").toString();
        HashRequest request = new HashRequest.Builder().setSalt((Object)dynaSalt).setSource((Object)encodedPassword).build();
        return hashService.computeHash(request).toHex();
    }
}

