/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.log;

import java.lang.reflect.Method;
import java.util.Date;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunTimeLogAdvice
implements MethodInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(RunTimeLogAdvice.class);
    private long minTime = 100L;

    public void setMinTime(long minTime) {
        this.minTime = minTime;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        long start = System.currentTimeMillis();
        Object result = invocation.proceed();
        long time = System.currentTimeMillis() - start;
        if (time > this.minTime && LOGGER.isInfoEnabled()) {
            StringBuilder builder = new StringBuilder();
            builder.append("ElapsedTime=");
            builder.append(time).append(" Method=");
            builder.append(RunTimeLogAdvice.methodToString(invocation.getMethod()));
            if (LOGGER.isDebugEnabled()) {
                builder.append(" Args={");
                RunTimeLogAdvice.appendArguments(builder, invocation.getArguments());
                builder.append('}');
                LOGGER.debug(builder.toString());
            } else {
                LOGGER.info(builder.toString());
            }
        }
        return result;
    }

    private static void appendArguments(StringBuilder builder, Object[] args) {
        if (args == null) {
            return;
        }
        for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            if (arg == null) {
                builder.append("null");
            } else if (arg.getClass().isPrimitive()) {
                builder.append(arg);
            } else if (arg instanceof Number) {
                builder.append(arg);
            } else if (arg instanceof String) {
                builder.append(arg);
            } else if (arg instanceof Date) {
                builder.append(arg);
            } else if (arg instanceof Boolean) {
                builder.append(arg);
            } else {
                builder.append(ToStringBuilder.reflectionToString((Object)arg));
            }
            if (i >= args.length - 1) continue;
            builder.append(',');
        }
    }

    private static String getTypeName(Class<?> type) {
        if (type.isArray()) {
            try {
                Class<?> cl = type;
                int dimensions = 0;
                while (cl.isArray()) {
                    ++dimensions;
                    cl = cl.getComponentType();
                }
                StringBuilder sb = new StringBuilder();
                sb.append(cl.getName());
                for (int i = 0; i < dimensions; ++i) {
                    sb.append("[]");
                }
                return sb.toString();
            }
            catch (Exception e) {
                LOGGER.warn("{}", (Throwable)e);
            }
        }
        return type.getName();
    }

    private static String methodToString(Method method) {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append(RunTimeLogAdvice.getTypeName(method.getDeclaringClass())).append('.');
            sb.append(method.getName()).append('(');
            Class<?>[] params = method.getParameterTypes();
            for (int j = 0; j < params.length; ++j) {
                sb.append(RunTimeLogAdvice.getTypeName(params[j]));
                if (j >= params.length - 1) continue;
                sb.append(',');
            }
            sb.append(')');
            return sb.toString();
        }
        catch (Exception e) {
            return RunTimeLogAdvice.concat("<", e, ">");
        }
    }

    private static String concat(Object ... sources) {
        if (sources == null) {
            return "";
        }
        if (sources.length == 1) {
            return String.valueOf(sources[0]);
        }
        StringBuilder sb = new StringBuilder();
        for (Object o : sources) {
            sb.append(o);
        }
        return sb.toString();
    }
}

