/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.mail;

import freemarker.template.Template;
import freemarker.template.TemplateException;
import ins.framework.mail.MailService;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.mail.MailException;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.ui.freemarker.FreeMarkerTemplateUtils;
import org.springframework.util.Assert;
import org.springframework.web.servlet.view.freemarker.FreeMarkerConfigurer;

public class JavaMailServiceImpl
implements MailService,
InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(JavaMailServiceImpl.class);
    protected JavaMailSender mailSender;
    private FreeMarkerConfigurer mailTemplateEngine = null;

    public void setMailTemplateEngine(FreeMarkerConfigurer mailTemplateEngine) {
        this.mailTemplateEngine = mailTemplateEngine;
    }

    public void setMailSender(JavaMailSender mailSender) {
        this.mailSender = mailSender;
    }

    @Override
    public void send(SimpleMailMessage msg) {
        try {
            this.mailSender.send(msg);
        }
        catch (MailException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void send(String from, String to, String subject, String text) {
        SimpleMailMessage msg = new SimpleMailMessage();
        msg.setFrom(from);
        msg.setTo(to);
        msg.setSubject(subject);
        msg.setText(text);
        this.send(msg);
    }

    @Override
    public void send(SimpleMailMessage msg, String templateName, Map<String, Object> model) {
        String content = this.generateEmailContent(templateName, model);
        MimeMessage mimeMsg = this.mailSender.createMimeMessage();
        try {
            MimeMessageHelper helper = new MimeMessageHelper(mimeMsg, true, "utf-8");
            helper.setTo(msg.getTo());
            helper.setSubject(msg.getSubject());
            helper.setFrom(msg.getFrom());
            helper.setText(content, true);
        }
        catch (MessagingException ex) {
            LOGGER.error(ex.getMessage(), (Throwable)ex);
        }
        this.mailSender.send(mimeMsg);
    }

    public String generateEmailContent(String templateName, Map<String, Object> map) {
        try {
            Template t = this.mailTemplateEngine.getConfiguration().getTemplate(templateName);
            return FreeMarkerTemplateUtils.processTemplateIntoString((Template)t, map);
        }
        catch (TemplateException e) {
            LOGGER.error("Error while processing FreeMarker template ", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            LOGGER.error("Error while open template file ", (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.error("Error while generate Email Content ", (Throwable)e);
        }
        return null;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.mailSender, (String)"\u672a\u6ce8\u5165MailSender");
    }

    @Override
    public MimeMessageHelper createMimeMessageHelper() {
        MimeMessage message = this.mailSender.createMimeMessage();
        MimeMessageHelper helper = null;
        try {
            helper = new MimeMessageHelper(message, true, "GBK");
        }
        catch (MessagingException me) {
            throw new IllegalStateException(me);
        }
        return helper;
    }

    @Override
    public void send(MimeMessage mimeMessage) {
        this.mailSender.send(mimeMessage);
    }
}

