/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.mail;

import freemarker.template.Template;
import freemarker.template.TemplateException;
import ins.framework.mail.MailService;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;
import javax.mail.internet.MimeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.ui.freemarker.FreeMarkerTemplateUtils;
import org.springframework.web.servlet.view.freemarker.FreeMarkerConfigurer;

public class MockMailServiceImpl
implements MailService {
    private static final Logger LOGGER = LoggerFactory.getLogger(MockMailServiceImpl.class);
    private FreeMarkerConfigurer mailTemplateEngine = null;

    public void setMailTemplateEngine(FreeMarkerConfigurer mailTemplateEngine) {
        this.mailTemplateEngine = mailTemplateEngine;
    }

    @Override
    public void send(SimpleMailMessage msg) {
        StringBuilder mail = new StringBuilder(100);
        mail.append(this.getMailHeader(msg)).append('\n');
        mail.append(msg.getText());
        LOGGER.info(mail.toString());
    }

    @Override
    public void send(SimpleMailMessage msg, String templateName, Map<String, Object> model) {
        StringBuilder mail = new StringBuilder(100);
        mail.append(this.getMailHeader(msg)).append('\n');
        mail.append(this.generateEmailContent(templateName, model));
        LOGGER.info(mail.toString());
    }

    @Override
    public void send(String from, String to, String subject, String text) {
        SimpleMailMessage msg = new SimpleMailMessage();
        msg.setFrom(from);
        msg.setTo(to);
        msg.setSubject(subject);
        msg.setText(text);
        this.send(msg);
    }

    protected String getMailHeader(SimpleMailMessage msg) {
        StringBuilder header = new StringBuilder(100);
        header.append("To: ");
        for (String to : msg.getTo()) {
            header.append(to).append(';');
        }
        header.append("\nFrom: ").append(msg.getFrom());
        header.append("\nSubject: ").append(msg.getSubject());
        return header.toString();
    }

    public String generateEmailContent(String templateName, Map<String, Object> map) {
        try {
            Template t = this.mailTemplateEngine.getConfiguration().getTemplate(templateName);
            return FreeMarkerTemplateUtils.processTemplateIntoString((Template)t, map);
        }
        catch (TemplateException e) {
            LOGGER.error("Error while processing FreeMarker template ", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            LOGGER.error("Error while open template file ", (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.error("Error while generate Email Content ", (Throwable)e);
        }
        return null;
    }

    @Override
    public MimeMessageHelper createMimeMessageHelper() {
        LOGGER.error("not implements the method createMimeMessageHelper().");
        return null;
    }

    @Override
    public void send(MimeMessage mimeMessage) {
        LOGGER.error("not implements the method send(MimeMessage mimeMessage).");
    }
}

