/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.mybatis.generator;

import ins.framework.mybatis.generator.BaseGenerator;
import ins.framework.mybatis.generator.GenFileInfo;
import ins.framework.mybatis.generator.GenType;
import ins.framework.mybatis.generator.executer.DaoExecuter;
import ins.framework.mybatis.generator.executer.MyBatisBaseXmlExecuter;
import ins.framework.mybatis.generator.executer.MyBatisCustomXmlExecuter;
import ins.framework.mybatis.generator.executer.PoExecuter;
import ins.framework.mybatis.generator.executer.VoExecuter;
import ins.framework.mybatis.generator.schema.Table;
import ins.framework.mybatis.generator.util.GeneratorUtils;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Generator
extends BaseGenerator {
    private static final Logger log = LoggerFactory.getLogger(Generator.class);
    private GenFileInfo voInfo;
    private GenFileInfo poInfo;
    private GenFileInfo daoInfo;
    private GenFileInfo baseMapperXmlInfo;
    private GenFileInfo mapperXmlInfo;

    private String assemblePackage(String module, String catalog) {
        String result = this.genConfig.getBasePackage() + "." + module;
        if (catalog != null && catalog.trim().length() > 0) {
            result = result + "." + catalog;
        }
        return result;
    }

    private String assembleXmlPackage(String module) {
        String result = "";
        result = module != null && module.trim().length() > 0 ? module : "misc";
        return result;
    }

    private void resetFileInfo(String beanNameIn, String module) {
        String saveDir = this.genConfig.getSaveDir();
        String beanName = beanNameIn;
        if (this.genConfig.getIgnoreTablePrefixs() != null) {
            for (String ignoreTablePrefix : this.genConfig.getIgnoreTablePrefixs()) {
                ignoreTablePrefix = ignoreTablePrefix.replace("_", "");
                if (!beanName.toLowerCase().startsWith(ignoreTablePrefix.toLowerCase())) continue;
                beanName = beanName.substring(ignoreTablePrefix.length());
                break;
            }
        }
        String name = beanName + "Vo";
        String packageName = this.assemblePackage(module, "vo");
        String path = Generator.getFilePath(this.genConfig.getSaveDirForVo(), Generator.getPathFromPackageName(packageName));
        this.voInfo = new GenFileInfo(name, packageName, path);
        name = beanName;
        if (this.genConfig.keepPrefixForPO) {
            name = beanNameIn;
        }
        packageName = this.assemblePackage(module, "po");
        path = Generator.getFilePath(saveDir, Generator.getPathFromPackageName(packageName));
        this.poInfo = new GenFileInfo(name, packageName, path);
        name = beanName + "Dao";
        packageName = this.assemblePackage(module, "dao");
        path = Generator.getFilePath(saveDir, Generator.getPathFromPackageName(packageName));
        this.daoInfo = new GenFileInfo(name, packageName, path);
        name = beanName + "BaseDao";
        packageName = this.assembleXmlPackage(module);
        String xmlPath = Generator.getFilePath(this.genConfig.getSaveDirForXml(), "base");
        path = Generator.getFilePath(xmlPath, Generator.getPathFromPackageName(packageName));
        this.baseMapperXmlInfo = new GenFileInfo(name, packageName, path);
        name = beanName + "Dao";
        packageName = this.assembleXmlPackage(module);
        xmlPath = Generator.getFilePath(this.genConfig.getSaveDirForXml(), "custom");
        path = Generator.getFilePath(xmlPath, Generator.getPathFromPackageName(packageName));
        this.mapperXmlInfo = new GenFileInfo(name, packageName, path);
    }

    @Override
    protected void run(Table table, String module) throws IOException {
        log.info("============\u5904\u7406\u8868" + table.getName() + "==================");
        if (table.getPrimaryKeys().isEmpty()) {
            log.info("\u8868" + table.getName() + "\u6ca1\u6709\u4e3b\u952e\u5b57\u6bb5\uff0c\u5ffd\u7565\u751f\u6210\uff0c\u8bf7\u624b\u5de5\u7f16\u5199.");
            return;
        }
        String beanName = GeneratorUtils.getObjectName(table.getName());
        this.resetFileInfo(beanName, module);
        this.fileOvervide = false;
        if (this.containsGenType(GenType.VO) && this.validFile(this.voInfo.getPath(), this.voInfo.getName(), ".java")) {
            new VoExecuter(this.genConfig, this.voInfo).build(table);
        }
        this.fileOvervide = true;
        if (this.containsGenType(GenType.PO) && this.validFile(this.poInfo.getPath(), this.poInfo.getName(), ".java")) {
            new PoExecuter(this.genConfig, this.poInfo).build(table);
        }
        if (table.getPrimaryKeys().size() > 1) {
            log.info("\u8868" + table.getName() + "\u4e3a\u8054\u5408\u4e3b\u952e\uff0c\u5ffd\u7565dao\u548cmapper\u751f\u6210,\u8bf7\u624b\u5de5\u7f16\u5199.");
            return;
        }
        this.fileOvervide = false;
        if (this.containsGenType(GenType.DAO) && this.validFile(this.daoInfo.getPath(), this.daoInfo.getName(), ".java")) {
            new DaoExecuter(this.genConfig, this.daoInfo, this.poInfo).build(table);
        }
        this.fileOvervide = true;
        if (this.containsGenType(GenType.BASE_MAPPER_XML) && this.validFile(this.baseMapperXmlInfo.getPath(), this.baseMapperXmlInfo.getName(), ".xml")) {
            new MyBatisBaseXmlExecuter(this.genConfig, this.baseMapperXmlInfo, this.daoInfo, this.poInfo).build(table);
        }
        this.fileOvervide = false;
        if (this.containsGenType(GenType.MAPPER_XML) && this.validFile(this.mapperXmlInfo.getPath(), this.mapperXmlInfo.getName(), ".xml")) {
            new MyBatisCustomXmlExecuter(this.genConfig, this.mapperXmlInfo, this.daoInfo).build(table);
        }
    }
}

