/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.mybatis.generator.executer;

import ins.framework.mybatis.generator.GenConfig;
import ins.framework.mybatis.generator.GenFileInfo;
import ins.framework.mybatis.generator.executer.BaseExecuter;
import ins.framework.mybatis.generator.schema.Column;
import ins.framework.mybatis.generator.schema.PrimaryKey;
import ins.framework.mybatis.generator.schema.Table;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DaoExecuter
extends BaseExecuter {
    private static final Logger log = LoggerFactory.getLogger(DaoExecuter.class);
    private GenFileInfo daoInfo;
    private GenFileInfo poInfo;

    public DaoExecuter(GenConfig genConfig, GenFileInfo daoInfo, GenFileInfo poInfo) {
        super(genConfig);
        this.daoInfo = daoInfo;
        this.poInfo = poInfo;
    }

    @Override
    public void build(Table table) throws IOException {
        List<PrimaryKey> primaryKeys = table.getPrimaryKeys();
        if (primaryKeys.size() != 1) {
            throw new IllegalArgumentException("\u76ee\u524d\u53ea\u652f\u6301\u5355\u4e00\u4e3b\u952e\u7684\u8868");
        }
        PrimaryKey primaryKey = primaryKeys.get(0);
        Column idColumn = null;
        List<Column> columns = table.getColumns();
        int size = columns.size();
        for (int i = 0; i < size; ++i) {
            Column column = columns.get(i);
            if (!column.getName().equalsIgnoreCase(primaryKey.getColumnName())) continue;
            idColumn = column;
            break;
        }
        if (idColumn == null) {
            throw new IllegalArgumentException("\u627e\u4e0d\u5230\u4e3b\u952e\u540d\u5bf9\u5e94\u7684\u5b57\u6bb5");
        }
        File mapperFile = new File(this.daoInfo.getPath(), this.daoInfo.getName() + ".java");
        try (BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(mapperFile), "utf-8"));){
            bw.write("package " + this.daoInfo.getPackageName() + ";");
            bw.newLine();
            bw.newLine();
            bw.write("import org.apache.ibatis.annotations.Mapper;");
            bw.newLine();
            bw.newLine();
            bw.write("import " + this.poInfo.getPackageName() + "." + this.poInfo.getName() + ";");
            bw.newLine();
            bw.write("import ins.framework.mybatis.MybatisBaseDao;");
            bw.newLine();
            DaoExecuter.buildClassComment(bw, "", "\u8868" + this.getName(table.getName()) + "\u5bf9\u5e94\u7684\u57fa\u4e8eMyBatis\u5b9e\u73b0\u7684Dao\u63a5\u53e3<br/>\r\n * \u5728\u5176\u4e2d\u6dfb\u52a0\u81ea\u5b9a\u4e49\u65b9\u6cd5");
            bw.newLine();
            bw.write("@Mapper");
            bw.newLine();
            bw.write("public interface " + this.daoInfo.getName() + " extends MybatisBaseDao<" + this.poInfo.getName() + ", " + DaoExecuter.processType(idColumn) + "> {");
            bw.newLine();
            bw.newLine();
            bw.write("}");
            bw.flush();
        }
        log.info("Generate Dao file " + mapperFile.getAbsolutePath());
    }
}

