/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.mybatis.generator.executer;

import ins.framework.mybatis.generator.GenConfig;
import ins.framework.mybatis.generator.GenFileInfo;
import ins.framework.mybatis.generator.executer.BaseExecuter;
import ins.framework.mybatis.generator.schema.Column;
import ins.framework.mybatis.generator.schema.PrimaryKey;
import ins.framework.mybatis.generator.schema.Table;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MyBatisBaseXmlExecuter
extends BaseExecuter {
    private static final Logger log = LoggerFactory.getLogger(MyBatisBaseXmlExecuter.class);
    private GenFileInfo baseMapperXmlInfo;
    private GenFileInfo daoInfo;
    private GenFileInfo poInfo;

    public MyBatisBaseXmlExecuter(GenConfig genConfig, GenFileInfo baseMapperXmlInfo, GenFileInfo daoInfo, GenFileInfo poInfo) {
        super(genConfig);
        this.baseMapperXmlInfo = baseMapperXmlInfo;
        this.daoInfo = daoInfo;
        this.poInfo = poInfo;
    }

    @Override
    public void build(Table table) throws IOException {
        List<Column> columns = table.getColumns();
        File mapperXmlFile = new File(this.baseMapperXmlInfo.getPath(), this.baseMapperXmlInfo.getName() + ".xml");
        try (BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(mapperXmlFile)));){
            bw.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            bw.newLine();
            bw.write("<!DOCTYPE mapper PUBLIC \"-//mybatis.org//DTD Mapper 3.0//EN\" \"http://mybatis.org/dtd/mybatis-3-mapper.dtd\">");
            bw.newLine();
            bw.write("<!-- ============================================================== -->");
            bw.newLine();
            bw.write("<!-- ============================================================== -->");
            bw.newLine();
            bw.write("<!-- =======\u901a\u8fc7ins-framework-mybatis\u5de5\u5177\u81ea\u52a8\u751f\u6210\uff0c\u8bf7\u52ff\u624b\u5de5\u4fee\u6539\uff01======= -->");
            bw.newLine();
            bw.write("<!-- =======\u672c\u914d\u7f6e\u6587\u4ef6\u4e2d\u5b9a\u4e49\u7684\u8282\u70b9\u53ef\u5728\u81ea\u5b9a\u4e49\u914d\u7f6e\u6587\u4ef6\u4e2d\u76f4\u63a5\u4f7f\u7528\uff01       ======= -->");
            bw.newLine();
            bw.write("<!-- ============================================================== -->");
            bw.newLine();
            bw.write("<!-- ============================================================== -->");
            bw.newLine();
            bw.write("<mapper namespace=\"" + this.daoInfo.getPackageName() + "." + this.daoInfo.getName() + "\">");
            if (this.genConfig.isDefaultCache()) {
                bw.newLine();
                bw.write("\t<!-- \u9ed8\u8ba4\u5f00\u542f\u4e8c\u7ea7\u7f13\u5b58,\u4f7f\u7528Least Recently Used\uff08LRU\uff0c\u6700\u8fd1\u6700\u5c11\u4f7f\u7528\u7684\uff09\u7b97\u6cd5\u6765\u6536\u56de -->");
                bw.newLine();
                bw.write("\t<cache/>");
            }
            bw.newLine();
            List<PrimaryKey> primaryKeys = table.getPrimaryKeys();
            PrimaryKey primaryKey = primaryKeys.get(0);
            this.buildBaseDaoBaseResultMap(bw, table, primaryKey, columns);
            this.buildBaseDaoBaseColumnList(bw, table, primaryKey, columns);
            this.buildBaseDaoBaseSelectByEntityWhere(bw, table, primaryKey, columns);
            this.buildBaseDaoBaseSelectByEntity(bw, table, primaryKey, columns);
            this.buildBaseDaoSelectByPrimaryKey(bw, table, primaryKey, columns);
            this.buildBaseDaoSelectBatchByPrimaryKeys(bw, table, primaryKey, columns);
            this.buildBaseDaoSelectPage(bw, table, primaryKey, columns);
            this.buildBaseDaoDeleteByPrimaryKey(bw, table, primaryKey, columns);
            this.buildBaseDaoDeleteBatchByPrimaryKeys(bw, table, primaryKey, columns);
            this.buildBaseDaoInsert(bw, table, primaryKey, columns);
            this.buildBaseDaoInsertSelective(bw, table, primaryKey, columns);
            this.buildBaseDaoUpdateSelectiveByPrimaryKey(bw, table, primaryKey, columns);
            this.buildBaseDaoUpdateByPrimaryKey(bw, table, primaryKey, columns);
            bw.write("</mapper>");
            bw.flush();
        }
        log.info("Generate BaseXml file " + mapperXmlFile.getAbsolutePath());
    }

    protected void buildBaseDaoBaseResultMap(BufferedWriter bw, Table table, PrimaryKey primaryKey, List<Column> columns) throws IOException {
        int size = columns.size();
        bw.write("\t<!-- \u901a\u7528\u67e5\u8be2\u7ed3\u679c\u5bf9\u8c61-->");
        bw.newLine();
        bw.write("\t<resultMap id=\"BaseResultMap\" type=\"" + this.poInfo.getPackageName() + "." + this.poInfo.getName() + "\">");
        bw.newLine();
        for (int i = 0; i < size; ++i) {
            Column column = columns.get(i);
            if (column.getName().equalsIgnoreCase(primaryKey.getColumnName())) {
                bw.write("\t\t <id ");
            } else {
                bw.write("\t\t <result ");
            }
            bw.write("column=\"" + this.getName(column.getName()) + "\" ");
            bw.write("property=\"" + MyBatisBaseXmlExecuter.getInstanceName(column.getName()) + "\"/> ");
            bw.newLine();
        }
        bw.write("\t</resultMap>");
        bw.newLine();
        bw.newLine();
    }

    protected void buildBaseDaoBaseColumnList(BufferedWriter bw, Table table, PrimaryKey primaryKey, List<Column> columns) throws IOException {
        int size = columns.size();
        bw.write("\t<!-- \u901a\u7528\u67e5\u8be2\u7ed3\u679c\u5217-->");
        bw.newLine();
        bw.write(this.getName("\t<sql id=\"Base_Column_List\">"));
        bw.newLine();
        bw.write("\t\t");
        for (int i = 0; i < size; ++i) {
            Column column = columns.get(i);
            bw.write(" " + this.getName(column.getName()));
            if (i != size - 1) {
                bw.write(",");
            }
            if (i % 5 != 4) continue;
            bw.newLine();
            bw.write("\t\t");
        }
        bw.newLine();
        bw.write("\t</sql>");
        bw.newLine();
        bw.newLine();
    }

    protected void buildBaseDaoBaseSelectByEntityWhere(BufferedWriter bw, Table table, PrimaryKey primaryKey, List<Column> columns) throws IOException {
        int size = columns.size();
        bw.write("\t<!-- \u6309\u5bf9\u8c61\u67e5\u8be2\u8bb0\u5f55\u7684WHERE\u90e8\u5206 -->");
        bw.newLine();
        bw.write(this.getName("\t<sql id=\"Base_Select_By_Entity_Where\">"));
        bw.newLine();
        for (int i = 0; i < size; ++i) {
            Column column = columns.get(i);
            if ("deletedFlag".equalsIgnoreCase(MyBatisBaseXmlExecuter.getObjectName(column.getName()))) {
                bw.write("\t\t\tand " + this.getName(column.getName()) + " = '0'");
                bw.newLine();
                continue;
            }
            bw.write("\t\t<if test=\"" + MyBatisBaseXmlExecuter.getInstanceName(column.getName()) + " != null\" >");
            bw.newLine();
            bw.write("\t\t\tand " + this.getName(column.getName()) + " = #{" + MyBatisBaseXmlExecuter.getInstanceName(column.getName()) + "}");
            bw.newLine();
            bw.write("\t\t</if>");
            bw.newLine();
        }
        bw.write("\t</sql>");
        bw.newLine();
        bw.newLine();
    }

    protected void buildBaseDaoBaseSelectByEntity(BufferedWriter bw, Table table, PrimaryKey primaryKey, List<Column> columns) throws IOException {
        bw.write("\t<!-- \u6309\u5bf9\u8c61\u67e5\u8be2\u8bb0\u5f55\u7684SQL\u90e8\u5206 -->");
        bw.newLine();
        bw.write(this.getName("\t<sql id=\"Base_Select_By_Entity\">"));
        bw.newLine();
        bw.write("\t\tselect");
        bw.newLine();
        bw.write(this.getName("\t\t\t<include refid=\"Base_Column_List\" />"));
        bw.newLine();
        bw.write("\t\tfrom " + this.getName(table.getName()));
        bw.newLine();
        bw.write("\t\t<where>");
        bw.newLine();
        bw.write(this.getName("\t\t\t<include refid=\"Base_Select_By_Entity_Where\" />"));
        bw.newLine();
        bw.write("\t\t</where>");
        bw.newLine();
        bw.write("\t</sql>");
        bw.newLine();
        bw.newLine();
    }

    protected void buildBaseDaoSelectByPrimaryKey(BufferedWriter bw, Table table, PrimaryKey primaryKey, List<Column> columns) throws IOException {
        bw.write("\t<!-- \u6309\u4e3b\u952e\u67e5\u8be2\u4e00\u6761\u8bb0\u5f55 -->");
        bw.newLine();
        bw.write("\t<select id=\"selectByPrimaryKey\" resultMap=\"BaseResultMap\" parameterType=\"map\">");
        bw.newLine();
        bw.write("\t\tselect");
        bw.newLine();
        bw.write(this.getName("\t\t\t<include refid=\"Base_Column_List\" />"));
        bw.newLine();
        bw.write("\t\tfrom " + this.getName(table.getName()));
        bw.newLine();
        bw.write("\t\twhere " + this.getName(primaryKey.getColumnName()) + " = #{param1}");
        bw.newLine();
        bw.write("\t</select>");
        bw.newLine();
        bw.newLine();
    }

    protected void buildBaseDaoSelectBatchByPrimaryKeys(BufferedWriter bw, Table table, PrimaryKey primaryKey, List<Column> columns) throws IOException {
        bw.write("\t<!-- \u6309\u4e3b\u952eList\u67e5\u8be2\u591a\u6761\u8bb0\u5f55 -->");
        bw.newLine();
        bw.write("\t<select id=\"selectBatchByPrimaryKeys\" resultMap=\"BaseResultMap\" parameterType=\"map\">");
        bw.newLine();
        bw.write("\t\tselect");
        bw.newLine();
        bw.write(this.getName("\t\t\t<include refid=\"Base_Column_List\" />"));
        bw.newLine();
        bw.write("\t\tfrom " + this.getName(table.getName()));
        bw.newLine();
        bw.write("\t\twhere " + this.getName(primaryKey.getColumnName()) + " in");
        bw.newLine();
        bw.write("\t\t<foreach item=\"item\" index=\"index\" collection=\"list\" open=\"(\" separator=\",\" close=\")\">");
        bw.newLine();
        bw.write("\t\t\t#{item}");
        bw.newLine();
        bw.write("\t\t</foreach>");
        bw.newLine();
        bw.write("\t</select>");
        bw.newLine();
        bw.newLine();
    }

    protected void buildBaseDaoSelectOne(BufferedWriter bw, Table table, PrimaryKey primaryKey, List<Column> columns) throws IOException {
        bw.write("\t<!-- \u6309\u5bf9\u8c61\u67e5\u8be2\u4e00\u6761\u8bb0\u5f55 -->");
        bw.newLine();
        bw.write("\t<select id=\"selectOne\" resultMap=\"BaseResultMap\" parameterType=\"" + this.poInfo.getPackageName() + "." + this.poInfo.getName() + "\">");
        bw.newLine();
        bw.write(this.getName("\t\t<include refid=\"Base_Select_By_Entity\" />"));
        bw.newLine();
        bw.write("\t</select>");
        bw.newLine();
        bw.newLine();
    }

    protected void buildBaseDaoSelectPage(BufferedWriter bw, Table table, PrimaryKey primaryKey, List<Column> columns) throws IOException {
        bw.write("\t<!-- \u6309\u5bf9\u8c61\u67e5\u8be2\u4e00\u9875\u8bb0\u5f55\uff08\u591a\u6761\u8bb0\u5f55\uff09 -->");
        bw.newLine();
        bw.write("\t<select id=\"selectPage\" resultMap=\"BaseResultMap\" parameterType=\"" + this.poInfo.getPackageName() + "." + this.poInfo.getName() + "\">");
        bw.newLine();
        bw.write(this.getName("\t\t<include refid=\"Base_Select_By_Entity\" />"));
        bw.newLine();
        bw.write("\t</select>");
        bw.newLine();
        bw.newLine();
    }

    protected boolean containsDeleteFlagField(Table table) {
        List<Column> columns = table.getColumns();
        int size = columns.size();
        for (int i = 0; i < size; ++i) {
            Column column = columns.get(i);
            if (!"deletedFlag".equalsIgnoreCase(MyBatisBaseXmlExecuter.getObjectName(column.getName()))) continue;
            return true;
        }
        return false;
    }

    protected void buildBaseDaoDeleteByPrimaryKey(BufferedWriter bw, Table table, PrimaryKey primaryKey, List<Column> columns) throws IOException {
        bw.write("\t<!-- \u6309\u4e3b\u952e\u5220\u9664\u4e00\u6761\u8bb0\u5f55 -->");
        bw.newLine();
        bw.write("\t<delete id=\"deleteByPrimaryKey\" parameterType=\"map\">");
        bw.newLine();
        if (this.genConfig.isDeletedFlagMode() && this.containsDeleteFlagField(table)) {
            bw.write("\t\tupdate " + this.getName(table.getName()));
            bw.newLine();
            bw.write("\t\t<set>");
            bw.newLine();
            int size = columns.size();
            for (int i = 0; i < size; ++i) {
                Column column = columns.get(i);
                if ("deletedFlag".equalsIgnoreCase(MyBatisBaseXmlExecuter.getObjectName(column.getName()))) {
                    bw.write("\t\t\t");
                    bw.write(this.getName(column.getName()));
                    bw.write("= '1',");
                    bw.newLine();
                }
                if (this.genConfig.getVersionName().equalsIgnoreCase(MyBatisBaseXmlExecuter.getObjectName(column.getName()))) {
                    bw.write("\t\t\t");
                    bw.write(this.getName(column.getName()));
                    bw.write("=");
                    bw.write(this.getName(column.getName()));
                    bw.write("+1,");
                    bw.newLine();
                    continue;
                }
                if (!this.genConfig.getOperateTimeForHisName().equalsIgnoreCase(MyBatisBaseXmlExecuter.getObjectName(column.getName())) || !StringUtils.isNotBlank((CharSequence)this.genConfig.getOperateTimeForHisFunc())) continue;
                bw.write("\t\t\t");
                bw.write(this.getName(column.getName()));
                bw.write("=");
                bw.write(this.genConfig.getOperateTimeForHisFunc());
                bw.write(",");
                bw.newLine();
            }
            bw.write("\t\t</set>");
        } else {
            bw.write("\t\tdelete from " + this.getName(table.getName()));
        }
        bw.newLine();
        bw.write("\t\twhere " + this.getName(primaryKey.getColumnName()) + " = #{param1}");
        bw.newLine();
        bw.write("\t</delete>");
        bw.newLine();
        bw.newLine();
    }

    protected void buildBaseDaoDeleteBatchByPrimaryKeys(BufferedWriter bw, Table table, PrimaryKey primaryKey, List<Column> columns) throws IOException {
        bw.write("\t<!-- \u6309\u4e3b\u952eList\u5220\u9664\u591a\u6761\u8bb0\u5f55 -->");
        bw.newLine();
        bw.write("\t<delete id=\"deleteBatchByPrimaryKeys\" parameterType=\"map\">");
        bw.newLine();
        if (this.genConfig.isDeletedFlagMode() && this.containsDeleteFlagField(table)) {
            bw.write("\t\tupdate " + this.getName(table.getName()));
            bw.newLine();
            bw.write("\t\t<set>");
            bw.newLine();
            int size = columns.size();
            for (int i = 0; i < size; ++i) {
                Column column = columns.get(i);
                if ("deletedFlag".equalsIgnoreCase(MyBatisBaseXmlExecuter.getObjectName(column.getName()))) {
                    bw.write("\t\t\t");
                    bw.write(this.getName(column.getName()));
                    bw.write("= '1',");
                    bw.newLine();
                }
                if (this.genConfig.getVersionName().equalsIgnoreCase(MyBatisBaseXmlExecuter.getObjectName(column.getName()))) {
                    bw.write("\t\t\t");
                    bw.write(this.getName(column.getName()));
                    bw.write("=");
                    bw.write(this.getName(column.getName()));
                    bw.write("+1,");
                    bw.newLine();
                    continue;
                }
                if (!this.genConfig.getOperateTimeForHisName().equalsIgnoreCase(MyBatisBaseXmlExecuter.getObjectName(column.getName())) || !StringUtils.isNotBlank((CharSequence)this.genConfig.getOperateTimeForHisFunc())) continue;
                bw.write("\t\t\t");
                bw.write(this.getName(column.getName()));
                bw.write("=");
                bw.write(this.genConfig.getOperateTimeForHisFunc());
                bw.write(",");
                bw.newLine();
            }
            bw.write("\t\t</set>");
        } else {
            bw.write("\t\tdelete from " + this.getName(table.getName()));
        }
        bw.newLine();
        bw.write("\t\twhere " + this.getName(primaryKey.getColumnName()) + " in ");
        bw.newLine();
        bw.write("\t\t<foreach item=\"item\" index=\"index\" collection=\"list\" open=\"(\" separator=\",\" close=\")\">");
        bw.newLine();
        bw.write("\t\t\t#{item}");
        bw.newLine();
        bw.write("\t\t</foreach>");
        bw.newLine();
        bw.write("\t</delete>");
        bw.newLine();
        bw.newLine();
    }

    protected void buildBaseDaoInsert(BufferedWriter bw, Table table, PrimaryKey primaryKey, List<Column> columns) throws IOException {
        Column column;
        int i;
        int size = columns.size();
        bw.write("\t<!-- \u5b8c\u6574\u63d2\u5165\u4e00\u6761\u8bb0\u5f55-->");
        bw.newLine();
        bw.write("\t<insert id=\"insert\" parameterType=\"" + this.poInfo.getPackageName() + "." + this.poInfo.getName() + "\">");
        bw.newLine();
        bw.write("\t\tinsert into " + this.getName(table.getName()) + " (");
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < size; ++i) {
            column = columns.get(i);
            if (this.genConfig.getInsertTimeForHisName().equalsIgnoreCase(MyBatisBaseXmlExecuter.getObjectName(this.getName(column.getName())))) continue;
            sb.append(this.getName(column.getName()));
            if (i != size - 1) {
                sb.append(", ");
            }
            if (i % 5 != 4) continue;
            sb.append("\r\n\t\t\t");
        }
        if (sb.toString().endsWith(", \r\n\t\t\t")) {
            sb.delete(0, sb.length() - ", \r\n\t\t\t".length());
        }
        bw.write(sb.toString());
        bw.write(")");
        bw.newLine();
        bw.write("\t\tvalues(");
        sb.setLength(0);
        for (i = 0; i < size; ++i) {
            column = columns.get(i);
            if (this.genConfig.getInsertTimeForHisName().equalsIgnoreCase(MyBatisBaseXmlExecuter.getObjectName(column.getName()))) continue;
            if (this.genConfig.getOperateTimeForHisName().equalsIgnoreCase(MyBatisBaseXmlExecuter.getObjectName(column.getName()))) {
                sb.append(this.genConfig.getOperateTimeForHisFunc());
            } else if (this.genConfig.getVersionName().equalsIgnoreCase(MyBatisBaseXmlExecuter.getObjectName(column.getName()))) {
                sb.append("1");
            } else if ("deletedFlag".equalsIgnoreCase(MyBatisBaseXmlExecuter.getObjectName(column.getName()))) {
                sb.append("'0'");
            } else {
                sb.append("#{" + MyBatisBaseXmlExecuter.getInstanceName(column.getName()));
                sb.append("}");
            }
            if (i != size - 1) {
                sb.append(", ");
            }
            if (i % 5 != 4) continue;
            sb.append("\r\n\t\t\t");
        }
        if (sb.toString().endsWith(", \r\n\t\t\t")) {
            sb.delete(0, sb.length() - ", \r\n\t\t\t".length());
        }
        bw.write(sb.toString());
        bw.write(")");
        bw.newLine();
        bw.write("\t</insert>");
        bw.newLine();
        bw.newLine();
    }

    protected void buildBaseDaoInsertSelective(BufferedWriter bw, Table table, PrimaryKey primaryKey, List<Column> columns) throws IOException {
        Column column;
        int i;
        int size = columns.size();
        bw.write("\t<!-- \u63d2\u5165\u4e00\u6761\u8bb0\u5f55(\u4e3a\u7a7a\u7684\u5b57\u6bb5\u4e0d\u64cd\u4f5c) -->");
        bw.newLine();
        bw.write("\t<insert id=\"insertSelective\" parameterType=\"" + this.poInfo.getPackageName() + "." + this.poInfo.getName() + "\">");
        bw.newLine();
        bw.write("\t\tinsert into " + this.getName(table.getName()) + "");
        bw.newLine();
        bw.write("\t\t<trim prefix=\"(\" suffix=\")\" suffixOverrides=\",\" >");
        bw.newLine();
        for (i = 0; i < size; ++i) {
            column = columns.get(i);
            if (this.genConfig.getInsertTimeForHisName().equalsIgnoreCase(MyBatisBaseXmlExecuter.getObjectName(column.getName()))) continue;
            if (this.genConfig.getVersionName().equalsIgnoreCase(MyBatisBaseXmlExecuter.getObjectName(column.getName()))) {
                bw.write("\t\t\t" + this.getName(column.getName()) + ",");
                bw.newLine();
                continue;
            }
            if (this.genConfig.isDeletedFlagMode() && "deletedFlag".equalsIgnoreCase(MyBatisBaseXmlExecuter.getObjectName(column.getName()))) {
                bw.write("\t\t\t" + this.getName(column.getName()) + ",");
                bw.newLine();
                continue;
            }
            if (this.genConfig.getOperateTimeForHisName().equalsIgnoreCase(MyBatisBaseXmlExecuter.getObjectName(column.getName())) && StringUtils.isNotBlank((CharSequence)this.genConfig.getOperateTimeForHisFunc())) {
                bw.write("\t\t\t" + this.getName(column.getName()) + ",");
                bw.newLine();
                continue;
            }
            bw.write("\t\t\t<if test=\"" + MyBatisBaseXmlExecuter.getInstanceName(column.getName()) + " != null\" >");
            bw.newLine();
            bw.write("\t\t\t\t" + this.getName(column.getName()) + ",");
            bw.newLine();
            bw.write("\t\t\t</if>");
            bw.newLine();
        }
        bw.write("\t\t</trim>");
        bw.newLine();
        bw.write("\t\tvalues <trim prefix=\"(\" suffix=\")\" suffixOverrides=\",\" >");
        bw.newLine();
        for (i = 0; i < size; ++i) {
            column = columns.get(i);
            if (this.genConfig.getInsertTimeForHisName().equalsIgnoreCase(MyBatisBaseXmlExecuter.getObjectName(column.getName()))) continue;
            if (this.genConfig.getVersionName().equalsIgnoreCase(MyBatisBaseXmlExecuter.getObjectName(column.getName()))) {
                bw.write("\t\t\t1,");
                bw.newLine();
                continue;
            }
            if (this.genConfig.isDeletedFlagMode() && "deletedFlag".equalsIgnoreCase(MyBatisBaseXmlExecuter.getObjectName(column.getName()))) {
                bw.write("\t\t\t'0',");
                bw.newLine();
                continue;
            }
            if (this.genConfig.getOperateTimeForHisName().equalsIgnoreCase(MyBatisBaseXmlExecuter.getObjectName(column.getName())) && StringUtils.isNotBlank((CharSequence)this.genConfig.getOperateTimeForHisFunc())) {
                bw.write("\t\t\t");
                bw.write(this.genConfig.getOperateTimeForHisFunc());
                bw.write(",");
                bw.newLine();
                continue;
            }
            bw.write("\t\t\t<if test=\"" + MyBatisBaseXmlExecuter.getInstanceName(column.getName()) + " != null\" >");
            bw.newLine();
            bw.write("\t\t\t\t#{" + MyBatisBaseXmlExecuter.getInstanceName(column.getName()) + "},");
            bw.newLine();
            bw.write("\t\t\t</if>");
            bw.newLine();
        }
        bw.write("\t\t</trim>");
        bw.newLine();
        bw.write("\t</insert>");
        bw.newLine();
        bw.newLine();
    }

    protected void buildBaseDaoUpdateSelectiveByPrimaryKey(BufferedWriter bw, Table table, PrimaryKey primaryKey, List<Column> columns) throws IOException {
        int size = columns.size();
        bw.write("\t<!-- \u66f4\u65b0\u4e00\u6761\u8bb0\u5f55(\u4e3a\u7a7a\u7684\u5b57\u6bb5\u4e0d\u64cd\u4f5c) -->");
        bw.newLine();
        bw.write("\t<update id=\"updateSelectiveByPrimaryKey\" parameterType=\"" + this.poInfo.getPackageName() + "." + this.poInfo.getName() + "\">");
        bw.newLine();
        bw.write("\t\tupdate " + this.getName(table.getName()));
        bw.newLine();
        bw.write("\t\t<set>");
        bw.newLine();
        for (int i = 0; i < size; ++i) {
            Column column = columns.get(i);
            if (column.getName().equalsIgnoreCase(primaryKey.getColumnName()) || this.genConfig.getInsertTimeForHisName().equalsIgnoreCase(MyBatisBaseXmlExecuter.getObjectName(column.getName()))) continue;
            if (this.genConfig.getVersionName().equalsIgnoreCase(MyBatisBaseXmlExecuter.getObjectName(column.getName()))) {
                bw.write("\t\t\t");
                bw.write(this.getName(column.getName()));
                bw.write("=");
                bw.write(this.getName(column.getName()));
                bw.write("+1,");
                bw.newLine();
                continue;
            }
            if (this.genConfig.getOperateTimeForHisName().equalsIgnoreCase(MyBatisBaseXmlExecuter.getObjectName(column.getName())) && StringUtils.isNotBlank((CharSequence)this.genConfig.getOperateTimeForHisFunc())) {
                bw.write("\t\t\t");
                bw.write(this.getName(column.getName()));
                bw.write("=");
                bw.write(this.genConfig.getOperateTimeForHisFunc());
                bw.write(",");
                bw.newLine();
                continue;
            }
            bw.write("\t\t\t<if test=\"" + MyBatisBaseXmlExecuter.getInstanceName(column.getName()) + " != null\" >");
            bw.newLine();
            bw.write("\t\t\t\t" + this.getName(column.getName()) + "=#{" + MyBatisBaseXmlExecuter.getInstanceName(column.getName()) + "},");
            bw.newLine();
            bw.write("\t\t\t</if>");
            bw.newLine();
        }
        bw.write("\t\t</set>");
        bw.newLine();
        bw.write("\t\twhere " + this.getName(primaryKey.getColumnName()) + " = #{" + MyBatisBaseXmlExecuter.getInstanceName(primaryKey.getColumnName()) + "}");
        bw.newLine();
        bw.write("\t</update>");
        bw.newLine();
        bw.newLine();
    }

    protected void buildBaseDaoUpdateByPrimaryKey(BufferedWriter bw, Table table, PrimaryKey primaryKey, List<Column> columns) throws IOException {
        int size = columns.size();
        bw.write("\t<!-- \u5b8c\u6574\u66f4\u65b0\u4e00\u6761\u8bb0\u5f55 -->");
        bw.newLine();
        bw.write("\t<update id=\"updateByPrimaryKey\" parameterType=\"" + this.poInfo.getPackageName() + "." + this.poInfo.getName() + "\">");
        bw.newLine();
        bw.write("\t\tupdate " + this.getName(table.getName()));
        bw.newLine();
        bw.write("\t\tset ");
        for (int i = 0; i < size; ++i) {
            Column column = columns.get(i);
            if (column.getName().equalsIgnoreCase(primaryKey.getColumnName()) || this.genConfig.getInsertTimeForHisName().equalsIgnoreCase(MyBatisBaseXmlExecuter.getObjectName(column.getName()))) continue;
            if (this.genConfig.getVersionName().equalsIgnoreCase(MyBatisBaseXmlExecuter.getObjectName(column.getName()))) {
                bw.write(column.getName() + "=" + MyBatisBaseXmlExecuter.getInstanceName(column.getName()) + "+1");
            } else if (this.genConfig.getOperateTimeForHisName().equalsIgnoreCase(MyBatisBaseXmlExecuter.getObjectName(column.getName())) && StringUtils.isNotBlank((CharSequence)this.genConfig.getOperateTimeForHisFunc())) {
                bw.write(this.getName(column.getName()) + "=" + this.genConfig.getOperateTimeForHisFunc());
            } else {
                bw.write(this.getName(column.getName()) + "=#{" + MyBatisBaseXmlExecuter.getInstanceName(column.getName()) + "}");
            }
            if (i == size - 1) continue;
            bw.write(",");
            bw.newLine();
            bw.write("\t\t\t");
        }
        bw.newLine();
        bw.write("\t\twhere " + this.getName(primaryKey.getColumnName()) + " = #{" + MyBatisBaseXmlExecuter.getInstanceName(primaryKey.getColumnName()) + "}");
        bw.newLine();
        bw.write("\t</update>");
        bw.newLine();
        bw.newLine();
    }
}

