/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.mybatis.generator.executer;

import ins.framework.mybatis.generator.GenConfig;
import ins.framework.mybatis.generator.GenFileInfo;
import ins.framework.mybatis.generator.executer.BaseExecuter;
import ins.framework.mybatis.generator.schema.Table;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MyBatisCustomXmlExecuter
extends BaseExecuter {
    private static final Logger log = LoggerFactory.getLogger(MyBatisCustomXmlExecuter.class);
    private GenFileInfo mapperXmlInfo;
    private GenFileInfo daoInfo;

    public MyBatisCustomXmlExecuter(GenConfig genConfig, GenFileInfo mapperXmlInfo, GenFileInfo daoInfo) {
        super(genConfig);
        this.mapperXmlInfo = mapperXmlInfo;
        this.daoInfo = daoInfo;
    }

    @Override
    public void build(Table table) throws IOException {
        File mapperXmlFile = new File(this.mapperXmlInfo.getPath(), this.mapperXmlInfo.getName() + ".xml");
        try (BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(mapperXmlFile)));){
            bw.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            bw.newLine();
            bw.write("<!DOCTYPE mapper PUBLIC \"-//mybatis.org//DTD Mapper 3.0//EN\" \"http://mybatis.org/dtd/mybatis-3-mapper.dtd\">");
            bw.newLine();
            bw.write("<!-- ============================================================== -->");
            bw.newLine();
            bw.write("<!-- ================\u53ef\u76f4\u63a5\u4f7f\u7528Base\u914d\u7f6e\u6587\u4ef6\u4e2d\u5b9a\u4e49\u7684\u8282\u70b9\uff01================ -->");
            bw.newLine();
            bw.write("<!-- ============================================================== -->");
            bw.newLine();
            bw.write("<mapper namespace=\"" + this.daoInfo.getPackageName() + "." + this.daoInfo.getName() + "\">");
            bw.newLine();
            bw.write("  <!-- \u8bf7\u5728\u4e0b\u65b9\u6dfb\u52a0\u81ea\u5b9a\u4e49\u914d\u7f6e-->");
            bw.newLine();
            bw.newLine();
            bw.newLine();
            bw.write("</mapper>");
            bw.flush();
        }
        log.info("Generate Xml file " + mapperXmlFile.getAbsolutePath());
    }
}

